/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.core.NamespaceTable;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.util.NoOpNamespace;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceManager {
    private static final Namespace NO_OP_NAMESPACE = new NoOpNamespace();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final Map<UShort, Namespace> namespaces = Maps.newConcurrentMap();

    public NamespaceManager() {
        this.namespaceTable.putUri("http://opcfoundation.org/UA/", Unsigned.ushort(0));
    }

    public UShort registerUri(String namespaceUri) {
        UShort index = this.namespaceTable.addUri(namespaceUri);
        this.logger.info("registered namespace index={}, uri={}", (Object)index, (Object)namespaceUri);
        return index;
    }

    public void addNamespace(Namespace namespace) {
        Preconditions.checkNotNull((Object)this.namespaceTable.getIndex(namespace.getNamespaceUri()), (Object)"namespace must be registered prior to adding");
        this.namespaces.put(namespace.getNamespaceIndex(), namespace);
        this.logger.info("added namespace index={}, uri={}", (Object)namespace.getNamespaceIndex(), (Object)namespace.getNamespaceUri());
    }

    public <T extends Namespace> T registerAndAdd(String namespaceUri, Function<UShort, T> namespaceFunction) {
        UShort namespaceIndex = this.namespaceTable.addUri(namespaceUri);
        Namespace namespace = (Namespace)namespaceFunction.apply(namespaceIndex);
        this.namespaces.put(namespaceIndex, namespace);
        this.logger.info("registered and added namespace index={}, uri={}", (Object)namespace.getNamespaceIndex(), (Object)namespace.getNamespaceUri());
        return (T)namespace;
    }

    public Namespace getNamespace(int index) {
        return this.getNamespace(Unsigned.ushort(index));
    }

    public Namespace getNamespace(UShort index) {
        Namespace namespace = this.namespaces.get(index);
        return namespace != null ? namespace : NO_OP_NAMESPACE;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public Optional<NodeId> toNodeId(ExpandedNodeId expandedNodeId) {
        if (!expandedNodeId.isLocal()) {
            return Optional.empty();
        }
        String namespaceUri = expandedNodeId.getNamespaceUri();
        Object identifier = expandedNodeId.getIdentifier();
        IdType type = expandedNodeId.getType();
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            return Optional.of(this.createNodeId(expandedNodeId.getNamespaceIndex(), identifier, type));
        }
        UShort index = this.namespaceTable.getIndex(namespaceUri);
        if (index == null) {
            return Optional.empty();
        }
        return Optional.of(this.createNodeId(index, identifier, type));
    }

    private NodeId createNodeId(UShort namespaceIndex, Object identifier, IdType type) {
        switch (type) {
            case Numeric: {
                return new NodeId(namespaceIndex, (UInteger)identifier);
            }
            case String: {
                return new NodeId(namespaceIndex, (String)identifier);
            }
            case Guid: {
                return new NodeId(namespaceIndex, (UUID)identifier);
            }
            case Opaque: {
                return new NodeId(namespaceIndex, (ByteString)identifier);
            }
        }
        throw new UaRuntimeException(0x80020000L, "unhandled type: " + type);
    }
}

