/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.util.AsyncSemaphore;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class OpcUaSubscription
implements UaSubscription {
    private final Map<UInteger, OpcUaMonitoredItem> itemsByClientHandle = Maps.newConcurrentMap();
    private final Map<UInteger, OpcUaMonitoredItem> itemsByServerHandle = Maps.newConcurrentMap();
    private final List<UaSubscription.NotificationListener> notificationListeners = new CopyOnWriteArrayList<UaSubscription.NotificationListener>();
    private final AsyncSemaphore notificationSemaphore = new AsyncSemaphore(1);
    private volatile long lastSequenceNumber = 0L;
    private volatile double revisedPublishingInterval = 0.0;
    private volatile UInteger revisedLifetimeCount = Unsigned.uint(0);
    private volatile UInteger revisedMaxKeepAliveCount = Unsigned.uint(0);
    private volatile UInteger maxNotificationsPerPublish;
    private volatile boolean publishingEnabled;
    private volatile UByte priority;
    private final OpcUaClient client;
    private final UInteger subscriptionId;

    public OpcUaSubscription(OpcUaClient client, UInteger subscriptionId, double revisedPublishingInterval, UInteger revisedLifetimeCount, UInteger revisedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, boolean publishingEnabled, UByte priority) {
        this.client = client;
        this.subscriptionId = subscriptionId;
        this.revisedPublishingInterval = revisedPublishingInterval;
        this.revisedLifetimeCount = revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.publishingEnabled = publishingEnabled;
        this.priority = priority;
    }

    @Override
    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
        CompletableFuture<CreateMonitoredItemsResponse> future = this.client.createMonitoredItems(this.subscriptionId, timestampsToReturn, itemsToCreate);
        return future.thenApply(response -> {
            List<MonitoredItemCreateResult> results = ConversionUtil.l(response.getResults());
            ArrayList createdItems = Lists.newArrayListWithCapacity((int)itemsToCreate.size());
            for (int i = 0; i < itemsToCreate.size(); ++i) {
                MonitoredItemCreateRequest request = (MonitoredItemCreateRequest)itemsToCreate.get(i);
                MonitoredItemCreateResult result = results.get(i);
                OpcUaMonitoredItem item = new OpcUaMonitoredItem(request.getRequestedParameters().getClientHandle(), request.getItemToMonitor(), result.getMonitoredItemId(), result.getStatusCode(), result.getRevisedSamplingInterval(), result.getRevisedQueueSize(), result.getFilterResult(), request.getMonitoringMode());
                if (item.getStatusCode().isGood()) {
                    this.itemsByClientHandle.put(item.getClientHandle(), item);
                    this.itemsByServerHandle.put(item.getMonitoredItemId(), item);
                }
                createdItems.add(item);
            }
            return createdItems;
        });
    }

    @Override
    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate, BiConsumer<UaMonitoredItem, Integer> itemCreationCallback) {
        return this.notificationSemaphore.acquire().thenCompose(permit -> {
            CompletableFuture<List<UaMonitoredItem>> itemsFuture = this.createMonitoredItems(timestampsToReturn, itemsToCreate);
            return itemsFuture.whenComplete((items, ex) -> {
                try {
                    if (items != null) {
                        for (int i = 0; i < items.size(); ++i) {
                            UaMonitoredItem item = (UaMonitoredItem)items.get(i);
                            if (!item.getStatusCode().isGood()) continue;
                            itemCreationCallback.accept(item, i);
                        }
                    }
                }
                finally {
                    permit.release();
                }
            });
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> modifyMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemModifyRequest> itemsToModify) {
        CompletableFuture<ModifyMonitoredItemsResponse> future = this.client.modifyMonitoredItems(this.subscriptionId, timestampsToReturn, itemsToModify);
        return future.thenApply(response -> {
            ArrayList statusCodes = Lists.newArrayList();
            List<MonitoredItemModifyResult> results = ConversionUtil.l(response.getResults());
            for (int i = 0; i < results.size(); ++i) {
                MonitoredItemModifyRequest request = (MonitoredItemModifyRequest)itemsToModify.get(i);
                MonitoredItemModifyResult result = results.get(i);
                StatusCode statusCode = result.getStatusCode();
                OpcUaMonitoredItem item = this.itemsByServerHandle.get(request.getMonitoredItemId());
                if (item != null) {
                    item.setStatusCode(statusCode);
                    item.setRevisedSamplingInterval(result.getRevisedSamplingInterval());
                    item.setRevisedQueueSize(result.getRevisedQueueSize());
                    item.setFilterResult(result.getFilterResult());
                }
                statusCodes.add(statusCode);
            }
            return statusCodes;
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> deleteMonitoredItems(List<UaMonitoredItem> itemsToDelete) {
        List<UInteger> monitoredItemIds = itemsToDelete.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList());
        return this.client.deleteMonitoredItems(this.subscriptionId, monitoredItemIds).thenApply(response -> {
            List<StatusCode> results = ConversionUtil.l(response.getResults());
            for (UaMonitoredItem item : itemsToDelete) {
                this.itemsByClientHandle.remove(item.getClientHandle());
                this.itemsByServerHandle.remove(item.getMonitoredItemId());
            }
            return results;
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> setMonitoringMode(MonitoringMode monitoringMode, List<UaMonitoredItem> items) {
        List<UInteger> monitoredItemIds = items.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList());
        CompletableFuture<SetMonitoringModeResponse> future = this.client.setMonitoringMode(this.subscriptionId, monitoringMode, monitoredItemIds);
        return future.thenApply(response -> {
            List<StatusCode> results = ConversionUtil.l(response.getResults());
            for (int i = 0; i < monitoredItemIds.size(); ++i) {
                UInteger id = (UInteger)monitoredItemIds.get(i);
                OpcUaMonitoredItem item = this.itemsByServerHandle.get(id);
                StatusCode result = results.get(i);
                if (!result.isGood() || item == null) continue;
                item.setMonitoringMode(monitoringMode);
            }
            return results;
        });
    }

    @Override
    public CompletableFuture<StatusCode> setPublishingMode(boolean publishingEnabled) {
        return this.client.setPublishingMode(publishingEnabled, Lists.newArrayList((Object[])new UInteger[]{this.subscriptionId})).thenApply(response -> {
            StatusCode statusCode = ConversionUtil.l(response.getResults()).get(0);
            if (statusCode.isGood()) {
                this.setPublishingEnabled(publishingEnabled);
            }
            return statusCode;
        });
    }

    @Override
    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public double getRevisedPublishingInterval() {
        return this.revisedPublishingInterval;
    }

    @Override
    public UInteger getRevisedLifetimeCount() {
        return this.revisedLifetimeCount;
    }

    @Override
    public UInteger getRevisedMaxKeepAliveCount() {
        return this.revisedMaxKeepAliveCount;
    }

    @Override
    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    @Override
    public boolean isPublishingEnabled() {
        return this.publishingEnabled;
    }

    @Override
    public UByte getPriority() {
        return this.priority;
    }

    @Override
    public ImmutableList<UaMonitoredItem> getMonitoredItems() {
        return ImmutableList.copyOf(this.itemsByClientHandle.values());
    }

    @Override
    public void addNotificationListener(UaSubscription.NotificationListener listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public void removeNotificationListener(UaSubscription.NotificationListener listener) {
        this.notificationListeners.remove(listener);
    }

    List<UaSubscription.NotificationListener> getNotificationListeners() {
        return this.notificationListeners;
    }

    AsyncSemaphore getNotificationSemaphore() {
        return this.notificationSemaphore;
    }

    Map<UInteger, OpcUaMonitoredItem> getItemsByClientHandle() {
        return this.itemsByClientHandle;
    }

    Map<UInteger, OpcUaMonitoredItem> getItemsByServerHandle() {
        return this.itemsByServerHandle;
    }

    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    void setRevisedPublishingInterval(double revisedPublishingInterval) {
        this.revisedPublishingInterval = revisedPublishingInterval;
    }

    void setRevisedLifetimeCount(UInteger revisedLifetimeCount) {
        this.revisedLifetimeCount = revisedLifetimeCount;
    }

    void setRevisedMaxKeepAliveCount(UInteger revisedMaxKeepAliveCount) {
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
    }

    void setMaxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
    }

    void setPublishingEnabled(boolean publishingEnabled) {
        this.publishingEnabled = publishingEnabled;
    }

    void setPriority(UByte priority) {
        this.priority = priority;
    }

    void setLastSequenceNumber(long lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
    }
}

