/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.DataItemNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.AnalogItemType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

public class AnalogItemNode
extends DataItemNode
implements AnalogItemType {
    public AnalogItemNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> instrumentRange() {
        return this.getPropertyNode(AnalogItemType.INSTRUMENT_RANGE.getBrowseName());
    }

    @Override
    public CompletableFuture<Range> getInstrumentRange() {
        return this.getProperty(AnalogItemType.INSTRUMENT_RANGE);
    }

    @Override
    public CompletableFuture<StatusCode> setInstrumentRange(Range value) {
        return this.setProperty(AnalogItemType.INSTRUMENT_RANGE, value);
    }

    public CompletableFuture<PropertyNode> eURange() {
        return this.getPropertyNode(AnalogItemType.E_U_RANGE.getBrowseName());
    }

    @Override
    public CompletableFuture<Range> getEURange() {
        return this.getProperty(AnalogItemType.E_U_RANGE);
    }

    @Override
    public CompletableFuture<StatusCode> setEURange(Range value) {
        return this.setProperty(AnalogItemType.E_U_RANGE, value);
    }

    public CompletableFuture<PropertyNode> engineeringUnits() {
        return this.getPropertyNode(AnalogItemType.ENGINEERING_UNITS.getBrowseName());
    }

    @Override
    public CompletableFuture<EUInformation> getEngineeringUnits() {
        return this.getProperty(AnalogItemType.ENGINEERING_UNITS);
    }

    @Override
    public CompletableFuture<StatusCode> setEngineeringUnits(EUInformation value) {
        return this.setProperty(AnalogItemType.ENGINEERING_UNITS, value);
    }
}

