/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.StateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TransitionVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.StateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class StateMachineNode
extends BaseObjectNode
implements StateMachineType {
    public StateMachineNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<? extends StateVariableNode> currentState() {
        return this.getVariableComponent(QualifiedName.parse("0:CurrentState")).thenApply(StateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getCurrentState() {
        return ((CompletableFuture)this.currentState().thenCompose(UaVariableNode::getValue)).thenApply(o -> StateMachineNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setCurrentState(LocalizedText value) {
        return this.currentState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<? extends TransitionVariableNode> lastTransition() {
        return this.getVariableComponent(QualifiedName.parse("0:LastTransition")).thenApply(TransitionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getLastTransition() {
        return ((CompletableFuture)this.lastTransition().thenCompose(UaVariableNode::getValue)).thenApply(o -> StateMachineNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastTransition(LocalizedText value) {
        return this.lastTransition().thenCompose(node -> node.setValue(value));
    }
}

