/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.SessionsDiagnosticsSummaryNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SamplingIntervalDiagnosticsArrayNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerDiagnosticsSummaryNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.SubscriptionDiagnosticsArrayNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;

public class ServerDiagnosticsNode
extends BaseObjectNode
implements ServerDiagnosticsType {
    public ServerDiagnosticsNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> enabledFlag() {
        return this.getPropertyNode(ServerDiagnosticsType.ENABLED_FLAG.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getEnabledFlag() {
        return this.getProperty(ServerDiagnosticsType.ENABLED_FLAG);
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledFlag(Boolean value) {
        return this.setProperty(ServerDiagnosticsType.ENABLED_FLAG, value);
    }

    public CompletableFuture<ServerDiagnosticsSummaryNode> serverDiagnosticsSummary() {
        return this.getVariableComponent(QualifiedName.parse("0:ServerDiagnosticsSummary")).thenApply(ServerDiagnosticsSummaryNode.class::cast);
    }

    @Override
    public CompletableFuture<ServerDiagnosticsSummaryDataType> getServerDiagnosticsSummary() {
        return ((CompletableFuture)this.serverDiagnosticsSummary().thenCompose(UaVariableNode::getValue)).thenApply(o -> ServerDiagnosticsNode.cast(o, ServerDiagnosticsSummaryDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType value) {
        return this.serverDiagnosticsSummary().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SamplingIntervalDiagnosticsArrayNode> samplingIntervalDiagnosticsArray() {
        return this.getVariableComponent(QualifiedName.parse("0:SamplingIntervalDiagnosticsArray")).thenApply(SamplingIntervalDiagnosticsArrayNode.class::cast);
    }

    @Override
    public CompletableFuture<SamplingIntervalDiagnosticsDataType[]> getSamplingIntervalDiagnosticsArray() {
        return ((CompletableFuture)this.samplingIntervalDiagnosticsArray().thenCompose(UaVariableNode::getValue)).thenApply(o -> ServerDiagnosticsNode.cast(o, SamplingIntervalDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] value) {
        return this.samplingIntervalDiagnosticsArray().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SubscriptionDiagnosticsArrayNode> subscriptionDiagnosticsArray() {
        return this.getVariableComponent(QualifiedName.parse("0:SubscriptionDiagnosticsArray")).thenApply(SubscriptionDiagnosticsArrayNode.class::cast);
    }

    @Override
    public CompletableFuture<SubscriptionDiagnosticsDataType[]> getSubscriptionDiagnosticsArray() {
        return ((CompletableFuture)this.subscriptionDiagnosticsArray().thenCompose(UaVariableNode::getValue)).thenApply(o -> ServerDiagnosticsNode.cast(o, SubscriptionDiagnosticsDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] value) {
        return this.subscriptionDiagnosticsArray().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<SessionsDiagnosticsSummaryNode> sessionsDiagnosticsSummary() {
        return this.getObjectComponent(QualifiedName.parse("0:SessionsDiagnosticsSummary")).thenApply(SessionsDiagnosticsSummaryNode.class::cast);
    }
}

