/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.CertificateGroupFolderNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerConfigurationType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ServerConfigurationNode
extends BaseObjectNode
implements ServerConfigurationType {
    public ServerConfigurationNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> serverCapabilities() {
        return this.getPropertyNode(ServerConfigurationType.SERVER_CAPABILITIES.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getServerCapabilities() {
        return this.getProperty(ServerConfigurationType.SERVER_CAPABILITIES);
    }

    @Override
    public CompletableFuture<StatusCode> setServerCapabilities(String[] value) {
        return this.setProperty(ServerConfigurationType.SERVER_CAPABILITIES, value);
    }

    public CompletableFuture<PropertyNode> supportedPrivateKeyFormats() {
        return this.getPropertyNode(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getSupportedPrivateKeyFormats() {
        return this.getProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS);
    }

    @Override
    public CompletableFuture<StatusCode> setSupportedPrivateKeyFormats(String[] value) {
        return this.setProperty(ServerConfigurationType.SUPPORTED_PRIVATE_KEY_FORMATS, value);
    }

    public CompletableFuture<PropertyNode> maxTrustListSize() {
        return this.getPropertyNode(ServerConfigurationType.MAX_TRUST_LIST_SIZE.getBrowseName());
    }

    @Override
    public CompletableFuture<UInteger> getMaxTrustListSize() {
        return this.getProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxTrustListSize(UInteger value) {
        return this.setProperty(ServerConfigurationType.MAX_TRUST_LIST_SIZE, value);
    }

    public CompletableFuture<PropertyNode> multicastDnsEnabled() {
        return this.getPropertyNode(ServerConfigurationType.MULTICAST_DNS_ENABLED.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getMulticastDnsEnabled() {
        return this.getProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED);
    }

    @Override
    public CompletableFuture<StatusCode> setMulticastDnsEnabled(Boolean value) {
        return this.setProperty(ServerConfigurationType.MULTICAST_DNS_ENABLED, value);
    }

    public CompletableFuture<CertificateGroupFolderNode> certificateGroups() {
        return this.getObjectComponent(QualifiedName.parse("0:CertificateGroups")).thenApply(CertificateGroupFolderNode.class::cast);
    }
}

