/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.FiniteTransitionVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ProgramDiagnosticNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ProgramStateMachineType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ProgramDiagnosticDataType;

public class ProgramStateMachineNode
extends FiniteStateMachineNode
implements ProgramStateMachineType {
    public ProgramStateMachineNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> creatable() {
        return this.getPropertyNode(ProgramStateMachineType.CREATABLE.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getCreatable() {
        return this.getProperty(ProgramStateMachineType.CREATABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setCreatable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.CREATABLE, value);
    }

    public CompletableFuture<PropertyNode> deletable() {
        return this.getPropertyNode(ProgramStateMachineType.DELETABLE.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getDeletable() {
        return this.getProperty(ProgramStateMachineType.DELETABLE);
    }

    @Override
    public CompletableFuture<StatusCode> setDeletable(Boolean value) {
        return this.setProperty(ProgramStateMachineType.DELETABLE, value);
    }

    public CompletableFuture<PropertyNode> autoDelete() {
        return this.getPropertyNode(ProgramStateMachineType.AUTO_DELETE.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getAutoDelete() {
        return this.getProperty(ProgramStateMachineType.AUTO_DELETE);
    }

    @Override
    public CompletableFuture<StatusCode> setAutoDelete(Boolean value) {
        return this.setProperty(ProgramStateMachineType.AUTO_DELETE, value);
    }

    public CompletableFuture<PropertyNode> recycleCount() {
        return this.getPropertyNode(ProgramStateMachineType.RECYCLE_COUNT.getBrowseName());
    }

    @Override
    public CompletableFuture<Integer> getRecycleCount() {
        return this.getProperty(ProgramStateMachineType.RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setRecycleCount(Integer value) {
        return this.setProperty(ProgramStateMachineType.RECYCLE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> instanceCount() {
        return this.getPropertyNode(ProgramStateMachineType.INSTANCE_COUNT.getBrowseName());
    }

    @Override
    public CompletableFuture<UInteger> getInstanceCount() {
        return this.getProperty(ProgramStateMachineType.INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> maxInstanceCount() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_INSTANCE_COUNT.getBrowseName());
    }

    @Override
    public CompletableFuture<UInteger> getMaxInstanceCount() {
        return this.getProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxInstanceCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_INSTANCE_COUNT, value);
    }

    public CompletableFuture<PropertyNode> maxRecycleCount() {
        return this.getPropertyNode(ProgramStateMachineType.MAX_RECYCLE_COUNT.getBrowseName());
    }

    @Override
    public CompletableFuture<UInteger> getMaxRecycleCount() {
        return this.getProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxRecycleCount(UInteger value) {
        return this.setProperty(ProgramStateMachineType.MAX_RECYCLE_COUNT, value);
    }

    @Override
    public CompletableFuture<FiniteStateVariableNode> currentState() {
        return this.getVariableComponent(QualifiedName.parse("0:CurrentState")).thenApply(FiniteStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getCurrentState() {
        return ((CompletableFuture)this.currentState().thenCompose(UaVariableNode::getValue)).thenApply(o -> ProgramStateMachineNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setCurrentState(LocalizedText value) {
        return this.currentState().thenCompose(node -> node.setValue(value));
    }

    @Override
    public CompletableFuture<FiniteTransitionVariableNode> lastTransition() {
        return this.getVariableComponent(QualifiedName.parse("0:LastTransition")).thenApply(FiniteTransitionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getLastTransition() {
        return ((CompletableFuture)this.lastTransition().thenCompose(UaVariableNode::getValue)).thenApply(o -> ProgramStateMachineNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastTransition(LocalizedText value) {
        return this.lastTransition().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ProgramDiagnosticNode> programDiagnostics() {
        return this.getVariableComponent(QualifiedName.parse("0:ProgramDiagnostics")).thenApply(ProgramDiagnosticNode.class::cast);
    }

    @Override
    public CompletableFuture<ProgramDiagnosticDataType> getProgramDiagnostics() {
        return ((CompletableFuture)this.programDiagnostics().thenCompose(UaVariableNode::getValue)).thenApply(o -> ProgramStateMachineNode.cast(o, ProgramDiagnosticDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> setProgramDiagnostics(ProgramDiagnosticDataType value) {
        return this.programDiagnostics().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseObjectNode> finalResultData() {
        return this.getObjectComponent(QualifiedName.parse("0:FinalResultData")).thenApply(BaseObjectNode.class::cast);
    }

    public CompletableFuture<StateNode> ready() {
        return this.getObjectComponent(QualifiedName.parse("0:Ready")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> running() {
        return this.getObjectComponent(QualifiedName.parse("0:Running")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> suspended() {
        return this.getObjectComponent(QualifiedName.parse("0:Suspended")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> halted() {
        return this.getObjectComponent(QualifiedName.parse("0:Halted")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<TransitionNode> haltedToReady() {
        return this.getObjectComponent(QualifiedName.parse("0:HaltedToReady")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> readyToRunning() {
        return this.getObjectComponent(QualifiedName.parse("0:ReadyToRunning")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> runningToHalted() {
        return this.getObjectComponent(QualifiedName.parse("0:RunningToHalted")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> runningToReady() {
        return this.getObjectComponent(QualifiedName.parse("0:RunningToReady")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> runningToSuspended() {
        return this.getObjectComponent(QualifiedName.parse("0:RunningToSuspended")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> suspendedToRunning() {
        return this.getObjectComponent(QualifiedName.parse("0:SuspendedToRunning")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> suspendedToHalted() {
        return this.getObjectComponent(QualifiedName.parse("0:SuspendedToHalted")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> suspendedToReady() {
        return this.getObjectComponent(QualifiedName.parse("0:SuspendedToReady")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> readyToHalted() {
        return this.getObjectComponent(QualifiedName.parse("0:ReadyToHalted")).thenApply(TransitionNode.class::cast);
    }
}

