/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ConditionVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class ConditionNode
extends BaseEventNode
implements ConditionType {
    public ConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> conditionClassId() {
        return this.getPropertyNode(ConditionType.CONDITION_CLASS_ID.getBrowseName());
    }

    @Override
    public CompletableFuture<NodeId> getConditionClassId() {
        return this.getProperty(ConditionType.CONDITION_CLASS_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionClassId(NodeId value) {
        return this.setProperty(ConditionType.CONDITION_CLASS_ID, value);
    }

    public CompletableFuture<PropertyNode> conditionClassName() {
        return this.getPropertyNode(ConditionType.CONDITION_CLASS_NAME.getBrowseName());
    }

    @Override
    public CompletableFuture<LocalizedText> getConditionClassName() {
        return this.getProperty(ConditionType.CONDITION_CLASS_NAME);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionClassName(LocalizedText value) {
        return this.setProperty(ConditionType.CONDITION_CLASS_NAME, value);
    }

    public CompletableFuture<PropertyNode> conditionName() {
        return this.getPropertyNode(ConditionType.CONDITION_NAME.getBrowseName());
    }

    @Override
    public CompletableFuture<String> getConditionName() {
        return this.getProperty(ConditionType.CONDITION_NAME);
    }

    @Override
    public CompletableFuture<StatusCode> setConditionName(String value) {
        return this.setProperty(ConditionType.CONDITION_NAME, value);
    }

    public CompletableFuture<PropertyNode> branchId() {
        return this.getPropertyNode(ConditionType.BRANCH_ID.getBrowseName());
    }

    @Override
    public CompletableFuture<NodeId> getBranchId() {
        return this.getProperty(ConditionType.BRANCH_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setBranchId(NodeId value) {
        return this.setProperty(ConditionType.BRANCH_ID, value);
    }

    public CompletableFuture<PropertyNode> retain() {
        return this.getPropertyNode(ConditionType.RETAIN.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getRetain() {
        return this.getProperty(ConditionType.RETAIN);
    }

    @Override
    public CompletableFuture<StatusCode> setRetain(Boolean value) {
        return this.setProperty(ConditionType.RETAIN, value);
    }

    public CompletableFuture<PropertyNode> clientUserId() {
        return this.getPropertyNode(ConditionType.CLIENT_USER_ID.getBrowseName());
    }

    @Override
    public CompletableFuture<String> getClientUserId() {
        return this.getProperty(ConditionType.CLIENT_USER_ID);
    }

    @Override
    public CompletableFuture<StatusCode> setClientUserId(String value) {
        return this.setProperty(ConditionType.CLIENT_USER_ID, value);
    }

    public CompletableFuture<TwoStateVariableNode> enabledState() {
        return this.getVariableComponent(QualifiedName.parse("0:EnabledState")).thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.enabledState().thenCompose(UaVariableNode::getValue)).thenApply(o -> ConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.enabledState().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableNode> quality() {
        return this.getVariableComponent(QualifiedName.parse("0:Quality")).thenApply(ConditionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<StatusCode> getQuality() {
        return ((CompletableFuture)this.quality().thenCompose(UaVariableNode::getValue)).thenApply(o -> ConditionNode.cast(o, StatusCode.class));
    }

    @Override
    public CompletableFuture<StatusCode> setQuality(StatusCode value) {
        return this.quality().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableNode> lastSeverity() {
        return this.getVariableComponent(QualifiedName.parse("0:LastSeverity")).thenApply(ConditionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<UShort> getLastSeverity() {
        return ((CompletableFuture)this.lastSeverity().thenCompose(UaVariableNode::getValue)).thenApply(o -> ConditionNode.cast(o, UShort.class));
    }

    @Override
    public CompletableFuture<StatusCode> setLastSeverity(UShort value) {
        return this.lastSeverity().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ConditionVariableNode> comment() {
        return this.getVariableComponent(QualifiedName.parse("0:Comment")).thenApply(ConditionVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getComment() {
        return ((CompletableFuture)this.comment().thenCompose(UaVariableNode::getValue)).thenApply(o -> ConditionNode.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setComment(LocalizedText value) {
        return this.comment().thenCompose(node -> node.setValue(value));
    }
}

