/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.subscriptions;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public interface UaSubscriptionManager {
    public CompletableFuture<UaSubscription> createSubscription(double var1);

    public CompletableFuture<UaSubscription> createSubscription(double var1, UInteger var3, UInteger var4, UInteger var5, boolean var6, UByte var7);

    public CompletableFuture<UaSubscription> modifySubscription(UInteger var1, double var2);

    public CompletableFuture<UaSubscription> modifySubscription(UInteger var1, double var2, UInteger var4, UInteger var5, UInteger var6, UByte var7);

    public CompletableFuture<UaSubscription> deleteSubscription(UInteger var1);

    public ImmutableList<UaSubscription> getSubscriptions();

    public void addSubscriptionListener(SubscriptionListener var1);

    public void removeSubscriptionListener(SubscriptionListener var1);

    public static interface SubscriptionListener {
        default public void onKeepAlive(UaSubscription subscription, DateTime publishTime) {
        }

        default public void onStatusChanged(UaSubscription subscription, StatusCode status) {
        }

        default public void onPublishFailure(UaException exception) {
        }

        default public void onNotificationDataLost(UaSubscription subscription) {
        }

        default public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
        }
    }
}

