/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.subscriptions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.jooq.lambda.tuple.Tuple2;

public interface UaSubscription {
    public UInteger getSubscriptionId();

    public double getRevisedPublishingInterval();

    public UInteger getRevisedLifetimeCount();

    public UInteger getRevisedMaxKeepAliveCount();

    public UInteger getMaxNotificationsPerPublish();

    public boolean isPublishingEnabled();

    public UByte getPriority();

    public ImmutableList<UaMonitoredItem> getMonitoredItems();

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2);

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2, BiConsumer<UaMonitoredItem, Integer> var3);

    public CompletableFuture<List<StatusCode>> modifyMonitoredItems(TimestampsToReturn var1, List<MonitoredItemModifyRequest> var2);

    public CompletableFuture<List<StatusCode>> deleteMonitoredItems(List<UaMonitoredItem> var1);

    public CompletableFuture<List<StatusCode>> setMonitoringMode(MonitoringMode var1, List<UaMonitoredItem> var2);

    public CompletableFuture<StatusCode> setPublishingMode(boolean var1);

    public void addNotificationListener(NotificationListener var1);

    public void removeNotificationListener(NotificationListener var1);

    public static interface NotificationListener {
        default public void onDataChangeNotification(UaSubscription subscription, ImmutableList<Tuple2<UaMonitoredItem, DataValue>> itemValues, DateTime publishTime) {
        }

        default public void onEventNotification(UaSubscription subscription, ImmutableList<Tuple2<UaMonitoredItem, Variant[]>> itemEvents, DateTime publishTime) {
        }

        default public void onKeepAliveNotification(UaSubscription subscription, DateTime publishTime) {
        }

        default public void onStatusChangedNotification(UaSubscription subscription, StatusCode status) {
        }
    }
}

