/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.config;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class OpcUaClientConfigBuilder
extends UaTcpStackClientConfigBuilder {
    private Supplier<String> sessionName;
    private UInteger sessionTimeout = Unsigned.uint(120000);
    private UInteger maxResponseMessageSize = Unsigned.uint(0);
    private UInteger requestTimeout = Unsigned.uint(60000);
    private UInteger maxPendingPublishRequests = Unsigned.uint(0xFFFFFFFFL);
    private IdentityProvider identityProvider = new AnonymousProvider();

    public OpcUaClientConfigBuilder setSessionName(Supplier<String> sessionName) {
        this.sessionName = sessionName;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionTimeout(UInteger sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxResponseMessageSize(UInteger maxResponseMessageSize) {
        this.maxResponseMessageSize = maxResponseMessageSize;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxPendingPublishRequests(UInteger maxPendingPublishRequests) {
        this.maxPendingPublishRequests = maxPendingPublishRequests;
        return this;
    }

    public OpcUaClientConfigBuilder setRequestTimeout(UInteger requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setEndpointUrl(String endpointUrl) {
        super.setEndpointUrl(endpointUrl);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setEndpoint(EndpointDescription endpoint) {
        super.setEndpoint(endpoint);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setKeyPair(KeyPair keyPair) {
        super.setKeyPair(keyPair);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setCertificate(X509Certificate certificate) {
        super.setCertificate(certificate);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setApplicationName(LocalizedText applicationName) {
        super.setApplicationName(applicationName);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setApplicationUri(String applicationUri) {
        super.setApplicationUri(applicationUri);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setProductUri(String productUri) {
        super.setProductUri(productUri);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setChannelConfig(ChannelConfig channelConfig) {
        super.setChannelConfig(channelConfig);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setChannelLifetime(UInteger channelLifetime) {
        super.setChannelLifetime(channelLifetime);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setExecutor(ExecutorService executor) {
        super.setExecutor(executor);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setEventLoop(NioEventLoopGroup eventLoop) {
        super.setEventLoop(eventLoop);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setWheelTimer(HashedWheelTimer wheelTimer) {
        super.setWheelTimer(wheelTimer);
        return this;
    }

    @Override
    public OpcUaClientConfigBuilder setSecureChannelReauthenticationEnabled(boolean secureChannelReauthenticationEnabled) {
        super.setSecureChannelReauthenticationEnabled(secureChannelReauthenticationEnabled);
        return this;
    }

    @Override
    public OpcUaClientConfig build() {
        UaTcpStackClientConfig stackClientConfig = super.build();
        if (this.sessionName == null) {
            this.sessionName = () -> String.format("UaSession:%s:%s", stackClientConfig.getApplicationName().getText(), System.currentTimeMillis());
        }
        return new OpcUaClientConfigImpl(stackClientConfig, this.sessionName, this.sessionTimeout, this.maxResponseMessageSize, this.maxPendingPublishRequests, this.requestTimeout, this.identityProvider);
    }

    public static class OpcUaClientConfigImpl
    implements OpcUaClientConfig {
        private final UaTcpStackClientConfig stackClientConfig;
        private final Supplier<String> sessionName;
        private final UInteger sessionTimeout;
        private final UInteger maxResponseMessageSize;
        private final UInteger maxPendingPublishRequests;
        private final UInteger requestTimeout;
        private final IdentityProvider identityProvider;

        public OpcUaClientConfigImpl(UaTcpStackClientConfig stackClientConfig, Supplier<String> sessionName, UInteger sessionTimeout, UInteger maxResponseMessageSize, UInteger maxPendingPublishRequests, UInteger requestTimeout, IdentityProvider identityProvider) {
            this.stackClientConfig = stackClientConfig;
            this.sessionName = sessionName;
            this.sessionTimeout = sessionTimeout;
            this.maxResponseMessageSize = maxResponseMessageSize;
            this.maxPendingPublishRequests = maxPendingPublishRequests;
            this.requestTimeout = requestTimeout;
            this.identityProvider = identityProvider;
        }

        @Override
        public Supplier<String> getSessionName() {
            return this.sessionName;
        }

        @Override
        public UInteger getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public UInteger getMaxResponseMessageSize() {
            return this.maxResponseMessageSize;
        }

        @Override
        public UInteger getMaxPendingPublishRequests() {
            return this.maxPendingPublishRequests;
        }

        @Override
        public UInteger getRequestTimeout() {
            return this.requestTimeout;
        }

        @Override
        public IdentityProvider getIdentityProvider() {
            return this.identityProvider;
        }

        @Override
        public Optional<String> getEndpointUrl() {
            return this.stackClientConfig.getEndpointUrl();
        }

        @Override
        public Optional<EndpointDescription> getEndpoint() {
            return this.stackClientConfig.getEndpoint();
        }

        @Override
        public Optional<KeyPair> getKeyPair() {
            return this.stackClientConfig.getKeyPair();
        }

        @Override
        public Optional<X509Certificate> getCertificate() {
            return this.stackClientConfig.getCertificate();
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.stackClientConfig.getApplicationName();
        }

        @Override
        public String getApplicationUri() {
            return this.stackClientConfig.getApplicationUri();
        }

        @Override
        public String getProductUri() {
            return this.stackClientConfig.getProductUri();
        }

        @Override
        public ChannelConfig getChannelConfig() {
            return this.stackClientConfig.getChannelConfig();
        }

        @Override
        public UInteger getChannelLifetime() {
            return this.stackClientConfig.getChannelLifetime();
        }

        @Override
        public ExecutorService getExecutor() {
            return this.stackClientConfig.getExecutor();
        }

        @Override
        public NioEventLoopGroup getEventLoop() {
            return this.stackClientConfig.getEventLoop();
        }

        @Override
        public HashedWheelTimer getWheelTimer() {
            return this.stackClientConfig.getWheelTimer();
        }

        @Override
        public boolean isSecureChannelReauthenticationEnabled() {
            return this.stackClientConfig.isSecureChannelReauthenticationEnabled();
        }
    }
}

