/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.sdk.client.api.NodeCache;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeCache
implements NodeCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile long expireAfterNanos = Duration.ofMinutes(2L).toNanos();
    private volatile long maximumSize = 1024L;
    private volatile Cache<NodeId, Map<AttributeId, DataValue>> cache = this.buildCache();

    @Override
    public Optional<DataValue> getAttribute(NodeId nodeId, AttributeId attributeId) {
        Map attributes = (Map)this.cache.getIfPresent((Object)nodeId);
        try {
            return attributes == null ? Optional.empty() : Optional.ofNullable(attributes.get((Object)attributeId));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public void putAttribute(NodeId nodeId, AttributeId attributeId, DataValue attribute) {
        try {
            Map attributes = (Map)this.cache.get((Object)nodeId, () -> Collections.synchronizedMap(Maps.newEnumMap(AttributeId.class)));
            attributes.put(attributeId, attribute);
        }
        catch (ExecutionException e) {
            this.logger.error("Error loading value: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void invalidate(NodeId nodeId) {
        this.cache.invalidate((Object)nodeId);
    }

    @Override
    public void invalidate(NodeId nodeId, AttributeId attributeId) {
        Optional.ofNullable(this.cache.getIfPresent((Object)nodeId)).ifPresent(attributes -> {
            DataValue cfr_ignored_0 = (DataValue)attributes.remove((Object)attributeId);
        });
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public CacheStats getStats() {
        return this.cache.stats();
    }

    public synchronized void setExpireAfter(long duration, TimeUnit unit) {
        this.expireAfterNanos = unit.toNanos(duration);
        Cache<NodeId, Map<AttributeId, DataValue>> newCache = this.buildCache();
        newCache.putAll((Map)this.cache.asMap());
        this.cache = newCache;
    }

    public synchronized void setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        Cache<NodeId, Map<AttributeId, DataValue>> newCache = this.buildCache();
        newCache.putAll((Map)this.cache.asMap());
        this.cache = newCache;
    }

    private Cache<NodeId, Map<AttributeId, DataValue>> buildCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(this.expireAfterNanos, TimeUnit.NANOSECONDS).maximumSize(this.maximumSize).recordStats().build();
    }
}

