/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.camel.component.milo.NamespaceId;
import org.apache.camel.component.milo.PartialNodeId;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientItemConfiguration;
import org.apache.camel.component.milo.client.internal.SubscriptionManager;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class MiloClientConnection
implements AutoCloseable {
    private final MiloClientConfiguration configuration;
    private SubscriptionManager manager;
    private boolean initialized;
    private final OpcUaClientConfigBuilder clientConfiguration;

    public MiloClientConnection(MiloClientConfiguration configuration, OpcUaClientConfigBuilder clientConfiguration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration.clone();
        this.clientConfiguration = clientConfiguration;
    }

    protected void init() throws Exception {
        this.manager = new SubscriptionManager(this.configuration, this.clientConfiguration, Stack.sharedScheduledExecutor(), 10000L);
    }

    @Override
    public void close() throws Exception {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    protected synchronized void checkInit() {
        if (this.initialized) {
            return;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    public MonitorHandle monitorValue(MiloClientItemConfiguration configuration, Consumer<DataValue> valueConsumer) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(valueConsumer);
        this.checkInit();
        NamespaceId namespaceId = configuration.makeNamespaceId();
        PartialNodeId partialNodeId = configuration.makePartialNodeId();
        UInteger handle = this.manager.registerItem(namespaceId, partialNodeId, configuration.getSamplingInterval(), valueConsumer);
        return () -> this.manager.unregisterItem(handle);
    }

    public String getConnectionId() {
        return this.configuration.toCacheId();
    }

    public void writeValue(NamespaceId namespaceId, PartialNodeId partialNodeId, Object value, boolean await) {
        this.checkInit();
        this.manager.write(namespaceId, partialNodeId, this.mapValue(value), await);
    }

    private DataValue mapValue(Object value) {
        if (value instanceof DataValue) {
            return (DataValue)value;
        }
        if (value instanceof Variant) {
            return new DataValue((Variant)value);
        }
        return new DataValue(new Variant(value));
    }

    @FunctionalInterface
    public static interface MonitorHandle {
        public void unregister();
    }
}

