/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.examples.microbit.data;

import de.dentrassi.kura.addons.examples.microbit.data.Characteristic;
import de.dentrassi.kura.addons.examples.microbit.data.UuidParser;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.eclipse.kura.message.KuraPayload;

public enum Service {
    DEVICE_INFORMATION("0000180A00001000800000805F9B34FB", new Characteristic[]{new Characteristic("00002A2400001000800000805F9B34FB", Service.stringValue("modelNumber")), new Characteristic("00002A2500001000800000805F9B34FB", Service.stringValue("serialNumber")), new Characteristic("00002A2700001000800000805F9B34FB", Service.stringValue("hardwareRevision")), new Characteristic("00002A2900001000800000805F9B34FB", Service.stringValue("manufacturerName"))}),
    TEMPERATURE("E95D6100251D470AA062FA1922DFA9A8", new Characteristic[]{new Characteristic("E95D9250251D470AA062FA1922DFA9A8", (payload, data) -> payload.addMetric("temperature", (Object)data.get()))});

    private final Characteristic[] characteristics;
    private final UUID id;

    private Service(String id, Characteristic[] characteristics) {
        this.id = UuidParser.parse(id);
        this.characteristics = characteristics;
    }

    public UUID getId() {
        return this.id;
    }

    public Characteristic[] getCharacteristics() {
        return this.characteristics;
    }

    public static BiConsumer<KuraPayload, ByteBuffer> stringValue(String metricName) {
        return (payload, data) -> {
            try {
                payload.addMetric(metricName, (Object)StandardCharsets.UTF_8.newDecoder().decode((ByteBuffer)data).toString());
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        };
    }
}

