/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.examples.microbit.data;

import de.dentrassi.kura.addons.examples.microbit.data.UuidParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.kura.message.KuraPayload;

public class Characteristic {
    private final UUID id;
    private final BiConsumer<KuraPayload, ByteBuffer> consumer;
    private final Consumer<KuraPayload> whenMissing;

    public Characteristic(String id, BiConsumer<KuraPayload, ByteBuffer> consumer, Consumer<KuraPayload> whenMissing) {
        this.id = UuidParser.parse(id);
        this.consumer = consumer;
        this.whenMissing = whenMissing;
    }

    public Characteristic(String id, BiConsumer<KuraPayload, ByteBuffer> consumer) {
        this(id, consumer, ignore -> {});
    }

    public UUID getId() {
        return this.id;
    }

    public void handle(KuraPayload payload, byte[] data) {
        if (data != null) {
            this.consumer.accept(payload, ByteBuffer.wrap(data));
        } else {
            this.whenMissing.accept(payload);
        }
    }
}

