/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.examples.microbit;

import com.google.gson.GsonBuilder;
import de.dentrassi.kura.addons.examples.microbit.Config;
import de.dentrassi.kura.addons.examples.microbit.data.Characteristic;
import de.dentrassi.kura.addons.examples.microbit.data.Service;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraBluetoothIOException;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.bluetooth.le.BluetoothLeService;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class MicrobitComponent
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(MicrobitComponent.class);
    private ScheduledExecutorService executor;
    private Config config;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, bind="setCloudPublisher")
    private CloudPublisher cloudPublisher;
    private Pattern pattern;
    @Reference
    private BluetoothLeService bluetooth;
    private BluetoothLeAdapter adapter;
    private List<BluetoothLeDevice> devices = Collections.emptyList();

    protected void setCloudPublisher(CloudPublisher cloudPublisher) {
        logger.info("Setting cloud publisher: {}", (Object)cloudPublisher);
        this.cloudPublisher = cloudPublisher;
    }

    @Activate
    public void activate(Config config) {
        this.dumpProperties("activate", config);
        this.setConfig(config);
    }

    @Modified
    public void modified(Config config) {
        this.dumpProperties("modified", config);
        this.setConfig(config);
    }

    @Deactivate
    public void deactivate() {
        logger.info("Deactivate");
        this.stop();
    }

    protected static KuraMessage makeMessage() {
        return new KuraMessage(MicrobitComponent.makePayload());
    }

    protected static KuraPayload makePayload() {
        KuraPayload payload = new KuraPayload();
        payload.addMetric("value", (Object)"foo");
        return payload;
    }

    private boolean needRestart(Config config) {
        if (this.config == null) {
            return false;
        }
        if (!this.config.interfaceName().equals(config.interfaceName())) {
            return true;
        }
        return !this.config.namePrefix().equals(config.namePrefix());
    }

    private void setConfig(Config config) {
        if (!config.enabled()) {
            logger.info("Component is not enabled");
            this.stop();
            return;
        }
        if (this.needRestart(config)) {
            logger.info("Configuration changes require a restart");
            this.stop();
        }
        this.config = config;
        logger.info("Starting ...");
        this.start();
        logger.info("Starting ... done!");
    }

    private void refreshDevices() {
        logger.info("Refresh devices");
        this.devices = this.performScan();
    }

    private List<BluetoothLeDevice> performScan() {
        LinkedList<BluetoothLeDevice> result = new LinkedList<BluetoothLeDevice>();
        BluetoothLeAdapter adapter = this.adapter;
        if (adapter == null) {
            logger.info("No bluetooth adapter found -> no devices");
            return result;
        }
        Pattern pattern = this.pattern;
        if (pattern == null) {
            logger.info("No pattern set -> no device");
            return result;
        }
        logger.info("Adapter - name: {}, alias: {}, address: {}, interfaceName: {}, powered: {}, discovering: {}", new Object[]{adapter.getName(), adapter.getAlias(), adapter.getAddress(), adapter.getInterfaceName(), adapter.isPowered(), adapter.isDiscovering()});
        try {
            if (adapter.isDiscovering()) {
                logger.info("Stopping active discovery");
                adapter.stopDiscovery();
            }
            logger.info("Begin scan ({} seconds) ...", (Object)this.config.scanTime());
            for (BluetoothLeDevice device : (List)adapter.findDevices(this.config.scanTime()).get()) {
                String name = device.getName();
                logger.info("Device - Name: {}, Address: {}, Alias: {}, Icon: {}", new Object[]{name, device.getAddress(), device.getAlias(), device.getIcon()});
                logger.info("\tUUIDs: {}", (Object)device.getUUIDs());
                logger.info("\tManufacturer Data: {}", (Object)device.getManufacturerData());
                logger.info("\tService Data: {}", (Object)device.getServiceData());
                if (name == null || !pattern.matcher(name).matches()) continue;
                logger.info("Adding device: {}", (Object)name);
                result.add(device);
            }
            logger.info("Scan complete");
        }
        catch (Exception e) {
            logger.warn("Failed to scan for devices", (Throwable)e);
        }
        return result;
    }

    private void refreshData() {
        logger.info("Refresh data...");
        List<BluetoothLeDevice> devices = this.devices;
        for (BluetoothLeDevice device : devices) {
            try {
                this.refreshDevice(device);
            }
            catch (Exception e) {
                logger.info("Failed to refresh device data", (Throwable)e);
                try {
                    device.disconnect();
                    logger.info("Disconnected from device");
                }
                catch (Exception e2) {
                    logger.info("Failed to clean up after error", (Throwable)e2);
                }
                try {
                    device.cancelPairing();
                }
                catch (Exception e2) {
                    logger.info("Failed to clean up after error", (Throwable)e2);
                }
            }
        }
        logger.info("Refresh data... done!");
    }

    private void refreshDevice(BluetoothLeDevice device) throws Exception {
        logger.info("Refresh device: {} - connected: {}, paired: {}, legacyPairing: {}, blocked: {}, trusted: {}, resolved: {}", new Object[]{device.getName(), device.isConnected(), device.isPaired(), device.isLegacyPairing(), device.isBlocked(), device.isTrusted(), device.isServicesResolved()});
        if (!device.isConnected()) {
            logger.info("Connecting ...");
            device.connect();
            logger.info("Connecting ... done!");
        }
        if (this.config.introspect()) {
            this.introspect(device);
        }
        KuraPayload payload = new KuraPayload();
        HashMap<String, String> errors = new HashMap<String, String>();
        HashSet<String> missing = new HashSet<String>();
        for (Service service : Service.values()) {
            logger.info("\tProcessing {} - {}", (Object)service.name(), (Object)service.getId());
            try {
                BluetoothLeGattService s = device.findService(service.getId());
                if (s != null) {
                    for (Characteristic ch : service.getCharacteristics()) {
                        try {
                            MicrobitComponent.readValue(s, ch, payload);
                        }
                        catch (Exception e) {
                            errors.put(String.format("%s/%s", service.getId(), ch.getId()), e.getMessage());
                        }
                    }
                    continue;
                }
                missing.add(service.getId().toString());
            }
            catch (Exception e) {
                errors.put(service.getId().toString(), e.getMessage());
            }
        }
        LinkedHashMap<String, Cloneable> body = new LinkedHashMap<String, Cloneable>();
        if (!errors.isEmpty()) {
            body.put("errors", errors);
        }
        if (!missing.isEmpty()) {
            body.put("missing", missing);
        }
        logger.info("Metrics: {}", (Object)new GsonBuilder().setPrettyPrinting().create().toJson((Object)payload));
        logger.info("Body: {}", (Object)new GsonBuilder().setPrettyPrinting().create().toJson(body));
        payload.setBody(new GsonBuilder().create().toJson(body).getBytes(StandardCharsets.UTF_8));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("assetName", device.getAddress());
        logger.info("Properties: {}", properties);
        KuraMessage message = new KuraMessage(payload, properties);
        CloudPublisher publisher = this.cloudPublisher;
        if (publisher != null) {
            publisher.publish(message);
        } else {
            logger.info("Skipping publish due to missing publisher");
        }
    }

    private static void readValue(BluetoothLeGattService s, Characteristic ch, KuraPayload payload) throws KuraBluetoothIOException {
        logger.info("\t\tFinding: {}", (Object)ch.getId());
        try {
            byte[] v;
            BluetoothLeGattCharacteristic c = s.findCharacteristic(ch.getId());
            if (c != null) {
                logger.info("\t\tReading: {}", (Object)ch.getId());
                v = c.readValue();
            } else {
                v = null;
            }
            ch.handle(payload, v);
        }
        catch (KuraBluetoothResourceNotFoundException e) {
            ch.handle(payload, null);
        }
    }

    private void introspect(BluetoothLeDevice device) throws Exception {
        logger.info("Finding services");
        List services = device.findServices();
        logger.info("Found: {}", (Object)services.size());
        for (BluetoothLeGattService service : services) {
            logger.info("\tService - {} ({})", (Object)service.getUUID(), (Object)service.isPrimary());
            List chars = service.findCharacteristics();
            for (BluetoothLeGattCharacteristic c : chars) {
                byte[] value = null;
                try {
                    value = c.readValue();
                }
                catch (Exception e) {
                    logger.info("Failed to read value", (Throwable)e);
                }
                logger.info("\t\tCharacteristic: {} - {}", (Object)c.getUUID(), (Object)value);
            }
        }
    }

    private void start() {
        if (this.adapter == null) {
            this.adapter = this.bluetooth.getAdapter(this.config.interfaceName());
        }
        this.pattern = Pattern.compile(this.config.namePrefix());
        logger.info("Bluetooth adapter ({}) = {}", (Object)this.config.interfaceName(), (Object)this.adapter);
        if (this.adapter != null) {
            logger.info("\tPowered = {}", (Object)this.adapter.isPowered());
            if (!this.adapter.isPowered()) {
                logger.info("Activate bluetooth adapter...");
                this.adapter.setPowered(true);
            }
        }
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleWithFixedDelay(this::refreshDevices, 5L, 60L, TimeUnit.SECONDS);
            this.executor.scheduleWithFixedDelay(this::refreshData, 20L, 10L, TimeUnit.SECONDS);
        }
    }

    private void stop() {
        logger.info("Stopping ...");
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.devices = Collections.emptyList();
        this.adapter = null;
    }

    private void dumpProperties(String operation, Config config) {
        if (logger.isInfoEnabled()) {
            logger.info("=========== {} ===========", (Object)operation);
            logger.info("\t@bluetooth = {}", (Object)this.bluetooth);
            logger.info("\t'enabled' = '{}'", (Object)config.enabled());
            logger.info("=========== {} ===========", (Object)operation);
        }
    }
}

