/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.examples.microbit;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Icon;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(id="de.dentrassi.kura.addons.examples.microbit.MicrobitComponent", name="micro:bit", description="Micro:bit example component", icon={@Icon(resource="microbit.png", size=14)})
@interface Config {
    @AttributeDefinition(name="CloudPublisher Target Filter", description="Specifies, as an OSGi target filter, the pid of the Cloud Publisher used to publish messages to the cloud platform.")
    public String cloudPublisher_target() default "(kura.service.pid=changeme)";

    @AttributeDefinition(name="Enabled", description="Whether the component is enabled or not.")
    public boolean enabled() default false;

    @AttributeDefinition(name="Bluetooth Interface Name", description="The device name of the Bluetooth adapter.")
    public String interfaceName() default "hci0";

    @AttributeDefinition(name="Scan time (seconds)", description="The amount of time the service will scan for Bluetooth devices.")
    public long scanTime() default 10L;

    @AttributeDefinition(name="Introspect to log", description="This scan all services and characteristics from a device and write it to the log. It can be used to debug data.")
    public boolean introspect() default false;

    @AttributeDefinition(name="Device name pattern", description="A regular expression of the Bluetooth device name to look out for.")
    public String namePrefix() default "(^BBC micro\\:bit|^Drogue Low Energy).*";
}

