/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.internal;

import de.dentrassi.kura.addons.drools.Drools;
import de.dentrassi.kura.addons.drools.internal.DroolsImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ServiceActivator {
    private static final Logger logger = LoggerFactory.getLogger(ServiceActivator.class);
    private static final Collection<?> REQUIRED_CLASSES = new HashSet<String>(Arrays.asList("org.kie.internal.builder.KnowledgeBuilderFactoryService", "org.kie.api.KieServices", "org.drools.compiler.compiler.PMMLCompiler", "org.kie.api.io.KieResources"));
    private final DroolsImpl drools = new DroolsImpl();
    private ServiceDiscoveryImpl serviceDiscovery;
    private BundleContext context;
    private ServiceRegistration<Drools> registration;
    private ScheduledExecutorService executors;
    private ScheduledFuture<?> job;

    @Reference
    public void setServiceDiscovery(ServiceDiscoveryImpl serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
        this.executors = Executors.newScheduledThreadPool(1);
        this.job = this.executors.scheduleAtFixedRate(this::checkAndPublish, 0L, 1L, TimeUnit.SECONDS);
    }

    @Deactivate
    protected void deactivate() {
        this.shutdownChecker();
        this.publish(false);
    }

    private void shutdownChecker() {
        if (this.job != null) {
            this.job.cancel(false);
            this.job = null;
        }
        if (this.executors != null) {
            this.executors.shutdown();
            this.executors = null;
        }
    }

    protected void checkAndPublish() {
        this.publish(this.isReady());
    }

    protected boolean isReady() {
        ServiceDiscoveryImpl serviceDiscovery = this.serviceDiscovery;
        if (serviceDiscovery == null) {
            return false;
        }
        serviceDiscovery.reset();
        Map services = serviceDiscovery.getServices();
        return services.keySet().containsAll(REQUIRED_CLASSES);
    }

    protected void publish(boolean state) {
        if (state) {
            if (this.registration == null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Current Drools registry:");
                    for (String name : this.serviceDiscovery.getServices().keySet()) {
                        logger.info("\t{}", (Object)name);
                    }
                }
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("service.description", "Drools helper interface");
                this.registration = this.context.registerService(Drools.class, (Object)this.drools, properties);
                this.shutdownChecker();
            }
        } else if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }
}

