/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.internal;

import de.dentrassi.kura.addons.drools.Drools;
import io.glutamate.lang.ClassLoaders;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class DroolsImpl
implements Drools {
    @Override
    public Drools.KieBaseBuilder newKieBaseBuilder(BundleContext context) {
        return new KieBaseBuilderImplementation(context);
    }

    @Override
    public Drools.KnowledgeBuilderBaseBuilder newKnowledgeBuilderBaseBuilder(BundleContext context) {
        return new KnowledgeBuilderBaseBuilderImplementation(context);
    }

    private static final class KnowledgeBuilderBaseBuilderImplementation
    implements Drools.KnowledgeBuilderBaseBuilder {
        private Consumer<KnowledgeBuilder> customizer;
        private final ClassLoader classLoader;
        private KnowledgeBuilderConfiguration configuration;
        private KieBaseConfiguration baseConfiguration;

        public KnowledgeBuilderBaseBuilderImplementation(BundleContext context) {
            Objects.requireNonNull(context);
            this.classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
            this.configure(null, null);
        }

        @Override
        public Drools.KnowledgeBuilderBaseBuilder configure(Properties properties, Consumer<KnowledgeBuilderConfiguration> customizer) {
            this.configuration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)properties, (ClassLoader[])new ClassLoader[]{this.classLoader});
            if (customizer != null) {
                customizer.accept(this.configuration);
            }
            return this;
        }

        @Override
        public Drools.KnowledgeBuilderBaseBuilder configureBase(Properties properties, Consumer<KieBaseConfiguration> customizer) {
            this.baseConfiguration = KieServices.get().newKieBaseConfiguration(properties, this.classLoader);
            if (customizer != null) {
                customizer.accept(this.baseConfiguration);
            }
            return this;
        }

        @Override
        public Drools.KnowledgeBuilderBaseBuilder customize(Consumer<KnowledgeBuilder> customizer) {
            this.customizer = customizer;
            return this;
        }

        @Override
        public KieBase build() {
            KnowledgeBuilderImpl builder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.configuration);
            if (this.customizer != null) {
                this.customizer.accept((KnowledgeBuilder)builder);
            }
            return (KieBase)ClassLoaders.callWithClassLoader((ClassLoader)this.classLoader, () -> builder.newKnowledgeBase(this.baseConfiguration));
        }
    }

    private static final class KieBaseBuilderImplementation
    implements Drools.KieBaseBuilder {
        private final ClassLoader classLoader;
        private Properties baseConfigurationProperties;
        private Consumer<KieBaseConfiguration> customizeBaseConfiguration;
        private Consumer<KieFileSystem> fileSystemCustomizer;
        private ReleaseId releaseId;

        public KieBaseBuilderImplementation(BundleContext context) {
            this.classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
        }

        @Override
        public Drools.KieBaseBuilder baseConfigurationProperties(Properties baseConfigurationProperties) {
            this.baseConfigurationProperties = baseConfigurationProperties;
            return this;
        }

        @Override
        public Drools.KieBaseBuilder customizeBaseConfiguration(Consumer<KieBaseConfiguration> customizeBaseConfiguration) {
            this.customizeBaseConfiguration = customizeBaseConfiguration;
            return this;
        }

        @Override
        public Drools.KieBaseBuilder fileSystem(Consumer<KieFileSystem> fileSystem) {
            this.fileSystemCustomizer = fileSystem;
            return this;
        }

        @Override
        public Drools.KieBaseBuilder releaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
            return this;
        }

        @Override
        public KieBase build() {
            return (KieBase)ClassLoaders.callWithClassLoader((ClassLoader)this.classLoader, this::buildBase);
        }

        private KieBase buildBase() {
            KieServices services = KieServices.get();
            KieFileSystem fileSystem = services.newKieFileSystem();
            if (this.fileSystemCustomizer != null) {
                this.fileSystemCustomizer.accept(fileSystem);
            }
            ReleaseId release = this.releaseId == null ? services.getRepository().getDefaultReleaseId() : this.releaseId;
            KieContainer container = services.newKieContainer(release, this.classLoader);
            KieBaseConfiguration baseConfiguration = services.newKieBaseConfiguration(this.baseConfigurationProperties);
            if (this.customizeBaseConfiguration != null) {
                this.customizeBaseConfiguration.accept(baseConfiguration);
            }
            return container.newKieBase(baseConfiguration);
        }
    }
}

