/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.component.wires;

import de.dentrassi.kura.addons.drools.Configuration;
import de.dentrassi.kura.addons.drools.component.wires.AbstractDroolsWireComponent;
import de.dentrassi.kura.addons.drools.component.wires.Wires;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.wireadmin.Consumer;
import org.osgi.service.wireadmin.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ConfigurableComponent.class, WireComponent.class, WireReceiver.class, Consumer.class, WireEmitter.class, Producer.class}, property={"service.pid=de.dentrassi.kura.addons.drools.component.wires.DroolsProcess"})
public class DroolsProcess
extends AbstractDroolsWireComponent
implements WireReceiver,
WireEmitter {
    private static final Logger logger = LoggerFactory.getLogger(DroolsProcess.class);
    private String entryPoint;
    private boolean fireAllRules;
    private boolean delete;
    private String factPackage;
    private String factType;
    private Map<String, String> inputs;
    private Map<String, String> outputs;

    @Override
    @Reference
    public void setWireHelperService(WireHelperService wireHelperService) {
        super.setWireHelperService(wireHelperService);
    }

    @Override
    @Activate
    protected void activate(Map<String, ?> properties) throws Exception {
        this.entryPoint = Configuration.asString(properties, (String)"entryPoint");
        this.fireAllRules = Configuration.asBoolean(properties, (String)"fireAllRules", (boolean)true);
        this.delete = Configuration.asBoolean(properties, (String)"delete", (boolean)true);
        this.factPackage = Configuration.asString(properties, (String)"factPackage");
        this.factType = Configuration.asString(properties, (String)"factType");
        this.inputs = Configuration.asOptionalString(properties, (String)"inputs").map(DroolsProcess::parseMappings).orElse(null);
        this.outputs = Configuration.asOptionalString(properties, (String)"outputs").map(DroolsProcess::parseMappings).orElse(null);
        if (this.factPackage == null || this.factType == null || this.inputs == null || this.outputs == null) {
            return;
        }
        super.activate(properties);
    }

    @Override
    @Modified
    protected void modified(Map<String, ?> properties) throws Exception {
        super.modified(properties);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    private static Map<String, String> parseMappings(String input) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : input.split("\\s*[,;]\\s*")) {
            String[] toks = pair.split("\\=", 2);
            if (toks.length != 2) continue;
            result.put(toks[0], toks[1]);
        }
        return result;
    }

    @Override
    public void onWireReceive(WireEnvelope envelope) {
        this.withSession(session -> {
            try {
                this.processReceive(envelope, (KieSession)session);
            }
            catch (Exception e) {
                logger.warn("Failed to process", (Throwable)e);
            }
        });
    }

    private void processReceive(WireEnvelope envelope, KieSession session) {
        Object fact;
        KieSession ep = session;
        if (this.entryPoint != null && !this.entryPoint.isEmpty()) {
            ep = session.getEntryPoint(this.entryPoint);
        }
        if (ep == null) {
            return;
        }
        FactType factType = session.getKieBase().getFactType(this.factPackage, this.factType);
        if (factType == null) {
            logger.warn("Unable to find fact type: {}:{}", (Object)this.factPackage, (Object)this.factType);
            return;
        }
        try {
            fact = factType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to created fact instance: " + this.factPackage + ":" + this.factType, e);
        }
        Map<String, TypedValue<?>> values = Wires.toMap(envelope);
        for (Map.Entry<String, String> entry : this.inputs.entrySet()) {
            String target = entry.getKey();
            String source = entry.getValue();
            TypedValue<?> value = values.get(source);
            if (value == null) {
                logger.warn("Missing value: {}", (Object)source);
                throw new IllegalStateException();
            }
            factType.set(fact, target, value.getValue());
        }
        FactHandle handle = ep.insert(fact);
        if (this.fireAllRules) {
            session.fireAllRules();
        }
        HashMap result = new HashMap(this.outputs.size());
        for (Map.Entry<String, String> entry : this.outputs.entrySet()) {
            String target = entry.getKey();
            String source = entry.getValue();
            Object value = factType.get(fact, source);
            if (logger.isInfoEnabled()) {
                logger.info("Result - type: {}, value: {}", value != null ? value.getClass() : "<null>", value);
            }
            if (value == null) continue;
            result.put(target, TypedValues.newTypedValue((Object)value));
        }
        if (this.delete) {
            ep.delete(handle);
        }
        this.wireSupport.emit(Wires.toRecords(result));
    }
}

