/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.component.wires;

import de.dentrassi.kura.addons.drools.Configuration;
import de.dentrassi.kura.addons.drools.component.wires.AbstractDroolsWireComponent;
import java.util.Map;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.wireadmin.Consumer;

@Component(enabled=true, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ConfigurableComponent.class, WireComponent.class, WireReceiver.class, Consumer.class}, property={"service.pid=de.dentrassi.kura.addons.drools.component.wires.DroolsInsert"})
public class DroolsInsert
extends AbstractDroolsWireComponent
implements WireReceiver {
    private String entryPoint;
    private boolean fireAllRules;
    private boolean delete;

    @Override
    @Reference
    public void setWireHelperService(WireHelperService wireHelperService) {
        super.setWireHelperService(wireHelperService);
    }

    @Override
    @Activate
    protected void activate(Map<String, ?> properties) throws Exception {
        this.entryPoint = Configuration.asString(properties, (String)"entryPoint");
        this.fireAllRules = Configuration.asBoolean(properties, (String)"fireAllRules", (boolean)true);
        this.delete = Configuration.asBoolean(properties, (String)"delete");
        super.activate(properties);
    }

    @Override
    @Modified
    protected void modified(Map<String, ?> properties) throws Exception {
        super.modified(properties);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    public void onWireReceive(WireEnvelope envelope) {
        this.withSession(session -> this.processReceive(envelope, (KieSession)session));
    }

    private void processReceive(WireEnvelope envelope, KieSession session) {
        KieSession ep = session;
        if (this.entryPoint != null && !this.entryPoint.isEmpty()) {
            ep = session.getEntryPoint(this.entryPoint);
        }
        if (ep == null) {
            return;
        }
        FactHandle handle = ep.insert((Object)envelope);
        if (this.fireAllRules) {
            session.fireAllRules();
        }
        if (this.delete) {
            ep.delete(handle);
        }
    }
}

