/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.component;

import de.dentrassi.kura.addons.drools.Configuration;
import de.dentrassi.kura.addons.drools.Drools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import org.drools.core.io.impl.ReaderResource;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.SequentialAgendaOption;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class DroolsInstance
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(DroolsInstance.class);
    private Drools drools;
    private BundleContext context;
    private KieSession session;
    private ServiceRegistration<KieSession> registration;

    @Reference
    public void setDrools(Drools drools) {
        this.drools = drools;
    }

    @Activate
    public void activate(BundleContext context, Map<String, Object> properties) {
        this.context = context;
        if (!Configuration.asBoolean(properties, (String)"enabled")) {
            return;
        }
        try {
            String id = Configuration.asString(properties, (String)"id", (String)UUID.randomUUID().toString());
            Optional<EventProcessingOption> eventProcessingOption = Configuration.asOptionalString(properties, (String)"eventProcessingOption").map(EventProcessingOption::determineEventProcessingMode);
            String rules = Configuration.asString(properties, (String)"rules");
            String type = Configuration.asString(properties, (String)"type", (String)"DRL");
            Optional<SequentialAgendaOption> sequentialAgendaOption = Configuration.asOptionalString(properties, (String)"sequentialAgendaOption").map(SequentialAgendaOption::valueOf);
            boolean fireUntilHalt = Configuration.asBoolean(properties, (String)"fireUntilHalt");
            HashMap<ResourceType, List<String>> resources = new HashMap<ResourceType, List<String>>();
            if ("COMPOSITE".equals(type)) {
                this.readComposite(resources, rules);
            } else {
                ResourceType resourceType = ResourceType.getResourceType((String)type);
                resources.put(resourceType, Collections.singletonList(rules != null ? rules : ""));
            }
            this.session = this.drools.newKnowledgeBuilderBaseBuilder(context).configureBase(config -> {
                eventProcessingOption.ifPresent(arg_0 -> ((KieBaseConfiguration)config).setOption(arg_0));
                sequentialAgendaOption.ifPresent(arg_0 -> ((KieBaseConfiguration)config).setOption(arg_0));
            }).customize(builder -> {
                for (Map.Entry entry : resources.entrySet()) {
                    for (String s : (List)entry.getValue()) {
                        builder.add((Resource)new ReaderResource((Reader)new StringReader(s)), (ResourceType)entry.getKey());
                    }
                }
            }).build().newKieSession();
            this.setupGlobals(this.session);
            Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
            serviceProperties.put("service.pid", properties.get("service.pid"));
            serviceProperties.put("drools.session.id", id);
            this.registration = context.registerService(KieSession.class, (Object)this.session, serviceProperties);
            if (fireUntilHalt) {
                Thread t = new Thread(() -> ((KieSession)this.session).fireUntilHalt());
                t.setContextClassLoader(DroolsInstance.class.getClassLoader());
                t.setName("DroolsInstance-fireUntilHalt-" + id);
                t.start();
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        logger.error("Drools thread failed: " + t.getName(), e);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("Failed to configure drools session", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void readComposite(Map<ResourceType, List<String>> resources, final String rules) throws Exception {
        if (rules == null) {
            return;
        }
        MimeMultipart mm = new MimeMultipart(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(rules.getBytes());
            }

            public OutputStream getOutputStream() throws IOException {
                throw new UnsupportedOperationException();
            }

            public String getContentType() {
                return "text/plain";
            }

            public String getName() {
                return null;
            }
        });
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart body = mm.getBodyPart(i);
            String[] typeHeader = body.getHeader("Drools-Resource-Type");
            if (typeHeader == null || typeHeader.length <= 0 || typeHeader[0] == null) {
                throw new IllegalArgumentException("'Drools-Resource-Type' header missing");
            }
            String resourceTypeName = typeHeader[0];
            ResourceType resourceType = ResourceType.getResourceType((String)resourceTypeName);
            String content = body.getContent().toString();
            resources.computeIfAbsent(resourceType, k -> new LinkedList()).add(content);
        }
    }

    protected void setupGlobals(KieSession session) {
    }

    @Deactivate
    public void deactivate() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.session != null) {
            this.session.halt();
            this.session.dispose();
            this.session = null;
        }
    }

    @Modified
    public void modified(Map<String, Object> properties) throws Exception {
        this.deactivate();
        this.activate(this.context, properties);
    }
}

