/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kura.addons.drools.component.wires;

import de.dentrassi.kura.addons.drools.Configuration;
import de.dentrassi.kura.addons.drools.component.AbstractWireComponent;
import de.dentrassi.kura.addons.drools.component.Filters;
import de.dentrassi.kura.addons.drools.component.wires.DroolsListen;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.kie.api.runtime.KieSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractDroolsWireComponent
extends AbstractWireComponent {
    protected final BundleContext context = FrameworkUtil.getBundle(DroolsListen.class).getBundleContext();
    private SingleServiceTracker<KieSession> tracker;

    protected void setKieSession(ServiceReference<KieSession> serviceReference, KieSession session) {
    }

    protected void closeSessionTracker() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    protected void openSessionTracker(String sessionId) throws InvalidSyntaxException {
        this.closeSessionTracker();
        if (sessionId == null || sessionId.isEmpty()) {
            return;
        }
        Filter filter = this.context.createFilter(Filters.simpleFilter(KieSession.class, "drools.session.id", sessionId));
        this.tracker = new SingleServiceTracker(this.context, filter, this::setKieSession);
        this.tracker.open();
    }

    @Override
    protected void activate(Map<String, ?> properties) throws Exception {
        super.activate(properties);
        this.openSessionTracker(Configuration.asString(properties, (String)"session.id"));
    }

    @Override
    protected void deactivate() {
        this.closeSessionTracker();
        super.deactivate();
    }

    protected void withSession(Consumer<KieSession> consumer) {
        KieSession session = (KieSession)this.tracker.getService();
        if (session != null) {
            consumer.accept(session);
        }
    }
}

