/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.gateway.client.mqtt;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.kapua.gateway.client.Application;
import org.eclipse.kapua.gateway.client.BinaryPayloadCodec;
import org.eclipse.kapua.gateway.client.Credentials;
import org.eclipse.kapua.gateway.client.Module;
import org.eclipse.kapua.gateway.client.Topic;
import org.eclipse.kapua.gateway.client.mqtt.MqttApplication;
import org.eclipse.kapua.gateway.client.mqtt.MqttMessageHandler;
import org.eclipse.kapua.gateway.client.mqtt.MqttNamespace;
import org.eclipse.kapua.gateway.client.spi.AbstractApplication;
import org.eclipse.kapua.gateway.client.spi.AbstractClient;

public abstract class MqttClient
extends AbstractClient {
    private final String clientId;
    private final BinaryPayloadCodec codec;
    private MqttNamespace namespace;

    public MqttClient(ScheduledExecutorService executor, BinaryPayloadCodec codec, MqttNamespace namespace, String clientId, Set<Module> modules) {
        super(executor, modules);
        this.clientId = clientId;
        this.codec = codec;
        this.namespace = namespace;
    }

    protected void publish(String applicationId, Topic topic, ByteBuffer buffer) throws Exception {
        String mqttTopic = this.namespace.dataTopic(this.clientId, applicationId, topic);
        this.publishMqtt(mqttTopic, buffer);
    }

    public abstract void publishMqtt(String var1, ByteBuffer var2) throws Exception;

    protected abstract CompletionStage<?> subscribeMqtt(String var1, MqttMessageHandler var2) throws Exception;

    protected CompletionStage<?> subscribe(String applicationId, Topic topic, MqttMessageHandler messageHandler) throws Exception {
        String mqttTopic = this.namespace.dataTopic(this.clientId, applicationId, topic);
        return this.subscribeMqtt(mqttTopic, messageHandler);
    }

    protected void internalUnsubscribe(String applicationId, Collection<Topic> topics) throws Exception {
        Set<String> mqttTopics = topics.stream().map(topic -> this.namespace.dataTopic(this.clientId, applicationId, (Topic)topic)).collect(Collectors.toSet());
        this.unsubscribeMqtt(mqttTopics);
    }

    protected abstract void unsubscribeMqtt(Set<String> var1) throws Exception;

    public String getMqttClientId() {
        return this.clientId;
    }

    protected AbstractApplication internalCreateApplication(Application.Builder builder, String applicationId) {
        return new MqttApplication(this, applicationId, this.executor);
    }

    protected BinaryPayloadCodec getCodec() {
        return this.codec;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractClient.Builder<T> {
        private MqttNamespace namespace;
        private BinaryPayloadCodec codec;
        private Credentials.UserAndPassword userAndPassword;
        private String clientId;
        private URI broker;

        public T codec(BinaryPayloadCodec codec) {
            this.codec = codec;
            return (T)((Object)((Builder)this.builder()));
        }

        public BinaryPayloadCodec codec() {
            return this.codec;
        }

        public T namespace(MqttNamespace namespace) {
            this.namespace = namespace;
            return (T)((Object)((Builder)this.builder()));
        }

        public MqttNamespace namespace() {
            return this.namespace;
        }

        public T clientId(String clientId) {
            this.clientId = clientId;
            return (T)((Object)((Builder)this.builder()));
        }

        public String clientId() {
            return this.clientId;
        }

        public T credentials(Credentials.UserAndPassword userAndPassword) {
            this.userAndPassword = userAndPassword;
            return (T)((Object)((Builder)this.builder()));
        }

        public T broker(String broker) throws URISyntaxException {
            Objects.requireNonNull(broker);
            this.broker = new URI(broker);
            return (T)((Object)((Builder)this.builder()));
        }

        public T broker(URI broker) throws URISyntaxException {
            Objects.requireNonNull(broker);
            this.broker = broker;
            return (T)((Object)((Builder)this.builder()));
        }

        public URI broker() {
            return this.broker;
        }

        public Object credentials() {
            return this.userAndPassword;
        }
    }
}

