/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.gateway.client.mqtt;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.eclipse.kapua.gateway.client.ErrorHandler;
import org.eclipse.kapua.gateway.client.MessageHandler;
import org.eclipse.kapua.gateway.client.Payload;
import org.eclipse.kapua.gateway.client.Topic;
import org.eclipse.kapua.gateway.client.mqtt.MqttClient;
import org.eclipse.kapua.gateway.client.spi.AbstractApplication;
import org.eclipse.kapua.gateway.client.spi.AbstractClient;
import org.eclipse.kapua.gateway.client.spi.AbstractData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttApplication
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(MqttApplication.class);
    private MqttClient client;

    public MqttApplication(MqttClient client, String applicationId, Executor executor) {
        super((AbstractClient)client, applicationId, executor);
        this.client = client;
    }

    public AbstractData data(Topic topic) {
        return new AbstractData((AbstractApplication)this, topic);
    }

    protected void publish(Topic topic, Payload payload) throws Exception {
        logger.debug("Publishing values - {} -> {}", (Object)topic, (Object)payload.getValues());
        ByteBuffer buffer = this.client.getCodec().encode(payload, null);
        buffer.flip();
        this.client.publish(this.applicationId, topic, buffer);
    }

    protected CompletionStage<?> internalSubscribe(Topic topic, MessageHandler handler, ErrorHandler<? extends Throwable> errorHandler) throws Exception {
        return this.client.subscribe(this.applicationId, topic, (messageTopic, payload) -> {
            logger.debug("Received message for: {}", (Object)topic);
            try {
                this.handleMessage(handler, payload);
            }
            catch (Exception e) {
                try {
                    errorHandler.handleError((Throwable)e, null);
                }
                catch (Exception e1) {
                    throw e1;
                }
                catch (Throwable e1) {
                    throw new Exception(e1);
                }
            }
        });
    }

    protected void handleMessage(MessageHandler handler, ByteBuffer buffer) throws Exception {
        Payload payload = this.client.getCodec().decode(buffer);
        logger.debug("Received: {}", (Object)payload);
        handler.handleMessage(payload);
    }
}

