/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.kapua.smarthome;

import de.dentrassi.kapua.smarthome.internal.Configuration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.kapua.gateway.client.Application;
import org.eclipse.kapua.gateway.client.Client;
import org.eclipse.kapua.gateway.client.Credentials;
import org.eclipse.kapua.gateway.client.Errors;
import org.eclipse.kapua.gateway.client.Payload;
import org.eclipse.kapua.gateway.client.Sender;
import org.eclipse.kapua.gateway.client.Topic;
import org.eclipse.kapua.gateway.client.mqtt.paho.PahoClient;
import org.eclipse.kapua.gateway.client.profile.kura.KuraMqttProfile;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(properties={"OSGI-INF/persistence.properties"})
@Designate(ocd=Configuration.class)
public class PersistenceServiceImpl
implements PersistenceService {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceServiceImpl.class);
    private Client client;
    private Application app;

    public String getId() {
        return "kapua";
    }

    public String getLabel(Locale locale) {
        return "Eclipse Kapua";
    }

    public void store(Item item) {
        this.store(item, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Item item, String alias) {
        String key;
        logger.debug("Store - item: {}, alias: {}", (Object)item, (Object)alias);
        String string = key = alias == null ? item.getName() : alias;
        if (key == null || key.isEmpty()) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        State state = item.getState();
        if (state instanceof DecimalType) {
            data.put("value", ((DecimalType)state).longValue());
        } else if (state instanceof StringType) {
            data.put("value", state.toString());
        } else if (state instanceof OnOffType) {
            data.put("value", state.equals(OnOffType.ON));
        } else if (state instanceof UpDownType) {
            data.put("value", state.equals(UpDownType.UP));
        } else if (state instanceof PlayPauseType) {
            data.put("value", state.equals(PlayPauseType.PLAY));
        } else {
            return;
        }
        PersistenceServiceImpl persistenceServiceImpl = this;
        synchronized (persistenceServiceImpl) {
            if (this.app == null) {
                logger.debug("Not configured, discarding event");
                return;
            }
            Topic topic = Topic.of((String)key, (String[])new String[0]);
            Payload payload = Payload.of(data);
            logger.debug("Topic: {}, payload: {}", (Object)topic, (Object)payload);
            Sender sender = this.app.data(topic).errors(Errors.ignore());
            sender.send(payload);
        }
    }

    @Activate
    protected synchronized void activate(Map<String, ?> properties) throws Exception {
        String broker;
        if (logger.isWarnEnabled()) {
            logger.warn("Create new Kapua client: {}", new TreeMap(properties));
        }
        if ((broker = PersistenceServiceImpl.getOrDefault(properties, "brokerUrl", null)) == null || broker.isEmpty()) {
            logger.warn("Missing broker URL. Not starting.");
            return;
        }
        KuraMqttProfile profile = KuraMqttProfile.newProfile(PahoClient.Builder::new);
        profile.accountName(PersistenceServiceImpl.getOrDefault(properties, "accoutName", "kapua-sys"));
        profile.clientId(PersistenceServiceImpl.getOrDefault(properties, "clientId", UUID.randomUUID().toString()));
        profile.brokerUrl(broker);
        String user = PersistenceServiceImpl.getOrDefault(properties, "user", null);
        String password = PersistenceServiceImpl.getOrDefault(properties, "password", null);
        if (user != null && password != null) {
            profile.credentials(Credentials.userAndPassword((String)user, (String)password));
        }
        this.client = profile.build();
        this.app = this.client.buildApplication("smarthome").build();
    }

    private static String getOrDefault(Map<String, ?> properties, String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    @Deactivate
    protected synchronized void deactivate() throws Exception {
        if (this.client != null) {
            try {
                this.client.close();
            }
            finally {
                this.client = null;
                this.app = null;
            }
        }
    }

    @Modified
    protected synchronized void modified(Map<String, ?> properties) throws Exception {
        this.deactivate();
        this.activate(properties);
    }
}

