/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.w1.camel;

import de.dentrassi.iot.w1.SensorValue;
import de.dentrassi.iot.w1.camel.OneWireConsumer;
import de.dentrassi.iot.w1.io.Scanner;
import de.dentrassi.iot.w1.parser.ValueParser;
import de.dentrassi.iot.w1.polling.SensorPoller;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="w1", syntax="w1:*", title="One Wire", label="iot", consumerClass=OneWireConsumer.class)
public class OneWireEndpoint
extends DefaultEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(OneWireEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private final String remaining;
    private final Set<Consumer<Stream<SensorValue>>> listeners = new CopyOnWriteArraySet<Consumer<Stream<SensorValue>>>();
    private Scanner scanner;
    private ValueParser parser;
    private SensorPoller poller;

    public OneWireEndpoint(String endpointUri, String remaining, Component camelContext) {
        super(endpointUri, camelContext);
        logger.debug("New endpoint: {}", (Object)remaining);
        this.remaining = remaining;
    }

    public Producer createProducer() throws Exception {
        return null;
    }

    public OneWireConsumer createConsumer(Processor processor) throws Exception {
        return new OneWireConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scanner = this.remaining == null || "*".equals(this.remaining) ? new Scanner() : (this.remaining.startsWith("/") ? new Scanner(Paths.get(URI.create("file:" + this.remaining))) : new Scanner(Paths.get(URI.create(this.remaining))));
        this.parser = new ValueParser();
        this.poller = new SensorPoller(this.scanner, this.parser, 1L, TimeUnit.SECONDS, this::handleUpdate);
    }

    protected void doStop() throws Exception {
        if (this.poller == null) {
            this.poller.close();
            this.poller = null;
        }
        this.parser = null;
        this.scanner = null;
        super.doStop();
    }

    protected void handleUpdate(Stream<SensorValue> value) {
        for (Consumer<Stream<SensorValue>> listener : this.listeners) {
            try {
                listener.accept(value);
            }
            catch (Exception e) {
                logger.warn("Failed to process update for listener");
            }
        }
    }

    void addListener(Consumer<Stream<SensorValue>> listener) {
        this.listeners.add(listener);
    }

    void removeListener(Consumer<Stream<SensorValue>> listener) {
        this.listeners.remove(listener);
    }
}

