/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.w1.camel;

import de.dentrassi.iot.w1.SensorValue;
import de.dentrassi.iot.w1.camel.OneWireEndpoint;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;

public class OneWireConsumer
extends DefaultConsumer {
    private final OneWireEndpoint endpoint;
    private final Consumer<Stream<SensorValue>> listener = this::handleUpdate;

    public OneWireConsumer(OneWireEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.addListener(this.listener);
    }

    protected void doStop() throws Exception {
        this.endpoint.removeListener(this.listener);
        super.doStop();
    }

    public void handleUpdate(Stream<SensorValue> updates) {
        updates.forEach(this::handleUpdate);
    }

    protected void handleUpdate(SensorValue value) {
        Exchange exchange = this.getEndpoint().createExchange();
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)value);
        exchange.setIn((Message)message);
        try {
            this.getAsyncProcessor().process(exchange);
        }
        catch (Exception e) {
            this.log.debug("Failed to process message", (Throwable)e);
        }
    }
}

