/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector.string;

import de.dentrassi.iot.opentsdb.collector.CollectorBuilder;
import de.dentrassi.iot.opentsdb.collector.string.AbstractClassOptionsLocator;
import de.dentrassi.iot.opentsdb.collector.string.OptionsLocator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

public class StringOptions {
    private static final Set<OptionsLocator> STANDARD_LOCATORS;
    private final CollectorBuilder builder;
    private Collection<OptionsLocator> services;
    private final Map<String, CollectorBuilder.Option<?>> cache = new HashMap();

    public StringOptions(CollectorBuilder builder) {
        Objects.requireNonNull(builder);
        this.builder = builder;
    }

    public Set<String> put(Map<String, String> options) {
        Objects.requireNonNull(options);
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            Optional<CollectorBuilder.Option<?>> option = this.lookup(entry.getKey());
            if (option.isPresent()) {
                option.get().put(this.builder, entry.getValue());
                continue;
            }
            result.add(entry.getKey());
        }
        return result;
    }

    private Optional<CollectorBuilder.Option<?>> lookup(String key) {
        if (this.cache.containsKey(key)) {
            return Optional.ofNullable(this.cache.get(key));
        }
        CollectorBuilder.Option<?> result = this.from(key, STANDARD_LOCATORS);
        if (result == null) {
            result = this.from(key, this.getServices());
        }
        this.cache.put(key, result);
        return Optional.ofNullable(result);
    }

    private Collection<OptionsLocator> getServices() {
        if (this.services == null) {
            return this.services;
        }
        this.services = new LinkedList<OptionsLocator>();
        ServiceLoader<OptionsLocator> services = ServiceLoader.load(OptionsLocator.class, this.builder.getRequest().getClassLoader());
        services.forEach(this.services::add);
        return this.services;
    }

    private CollectorBuilder.Option<?> from(String key, Collection<OptionsLocator> locators) {
        for (OptionsLocator locator : locators) {
            if (!locator.getOptions().containsKey(key)) continue;
            return locator.getOptions().get(key);
        }
        return null;
    }

    public static Set<String> putAll(CollectorBuilder builder, Map<String, String> options) {
        return new StringOptions(builder).put(options);
    }

    static {
        HashSet<AbstractClassOptionsLocator> locators = new HashSet<AbstractClassOptionsLocator>();
        locators.add(new AbstractClassOptionsLocator(CollectorBuilder.StandardOptions.class));
        STANDARD_LOCATORS = Collections.unmodifiableSet(locators);
    }
}

