/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector.string;

import de.dentrassi.iot.opentsdb.collector.CollectorBuilder;
import de.dentrassi.iot.opentsdb.collector.string.OptionsLocator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AbstractClassOptionsLocator
implements OptionsLocator {
    private final Map<String, CollectorBuilder.Option<?>> map = new HashMap();

    public AbstractClassOptionsLocator(Class<?> ... clazzes) {
        for (Class<?> clazz : clazzes) {
            this.addClass(clazz);
        }
    }

    private void addClass(Class<?> clazz) {
        for (Field field : clazz.getFields()) {
            Class<?> optType;
            if (!Modifier.isStatic(field.getModifiers()) || !CollectorBuilder.Option.class.isAssignableFrom(optType = field.getType())) continue;
            String name = AbstractClassOptionsLocator.mapName(field.getName());
            try {
                this.map.put(name, (CollectorBuilder.Option)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, CollectorBuilder.Option<?>> getOptions() {
        return Collections.unmodifiableMap(this.map);
    }

    private static String mapName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpper = false;
        block3: for (char c : name.toCharArray()) {
            switch (c) {
                case '_': {
                    toUpper = true;
                    continue block3;
                }
                default: {
                    if (!toUpper) {
                        sb.append(Character.toLowerCase(c));
                        continue block3;
                    }
                    sb.append(Character.toUpperCase(c));
                    toUpper = false;
                }
            }
        }
        return sb.toString();
    }
}

