/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Data {
    private final String metric;
    private final Number value;
    private final Instant timestamp;
    private final Map<String, String> tags;

    public Data(String metric, long value, Instant timestamp, Map<String, String> tags) {
        this(metric, (Number)value, timestamp, tags);
    }

    public Data(String metric, float value, Instant timestamp, Map<String, String> tags) {
        this(metric, Float.valueOf(value), timestamp, tags);
    }

    private Data(String metric, Number value, Instant timestamp, Map<String, String> tags) {
        Objects.requireNonNull(metric);
        Objects.requireNonNull(value);
        Objects.requireNonNull(timestamp);
        Objects.requireNonNull(tags);
        this.metric = metric;
        this.value = value;
        this.timestamp = timestamp;
        this.tags = Collections.unmodifiableMap(new HashMap<String, String>(tags));
    }

    public String getMetric() {
        return this.metric;
    }

    public Number getValue() {
        return this.value;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }
}

