/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector;

import de.dentrassi.iot.opentsdb.collector.Collector;
import de.dentrassi.iot.opentsdb.collector.service.CollectorFactory;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;

public class CollectorBuilder {
    private final Request request = new Request();

    public CollectorBuilder(URL url) {
        this.request.url = url;
        this.defaultBackend();
    }

    public <T> CollectorBuilder option(Option<T> option, T value) {
        Objects.requireNonNull(option);
        this.request.options.put(option, value);
        return this;
    }

    public CollectorBuilder removeOption(Option<?> option) {
        Objects.requireNonNull(option);
        this.request.options.remove(option);
        return this;
    }

    public CollectorBuilder usingClassLoader(ClassLoader classLoader) {
        this.request.classLoader = classLoader;
        return this;
    }

    public CollectorBuilder contextClassLoader() {
        return this.usingClassLoader(null);
    }

    public CollectorBuilder backend(String backendName) {
        return this.option(StandardOptions.BACKEND, backendName);
    }

    public CollectorBuilder defaultBackend() {
        return this.removeOption(StandardOptions.BACKEND);
    }

    public CollectorBuilder httpBackend() {
        return this.backend("http");
    }

    public CollectorBuilder enableMilliseconds() {
        return this.milliseconds(true);
    }

    public CollectorBuilder milliseconds(boolean milliseconds) {
        return this.option(StandardOptions.MILLISECONDS, milliseconds);
    }

    public Request getRequest() {
        return this.request;
    }

    public Optional<Collector> build() {
        ServiceLoader<CollectorFactory> loader = ServiceLoader.load(CollectorFactory.class, this.request.getClassLoader());
        return Optional.ofNullable(this.tryWith(this.request, loader.iterator()));
    }

    private Collector tryWith(Request request, Iterator<CollectorFactory> iterator) {
        while (iterator.hasNext()) {
            CollectorFactory factory = iterator.next();
            if (factory == null || !factory.canBuild(request)) continue;
            return factory.build(request);
        }
        return null;
    }

    public static final class Request {
        private ClassLoader classLoader;
        private URL url;
        private final Map<Object, Object> options = new HashMap<Object, Object>();

        private Request() {
        }

        public ClassLoader getClassLoader() {
            if (this.classLoader == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        public Map<?, ?> getOptions() {
            return Collections.unmodifiableMap(this.options);
        }

        public String getBackend() {
            return StandardOptions.BACKEND.get(this.options);
        }
    }

    public static final class StandardOptions {
        public static final Option<String> BACKEND = new StringOption();
        public static final Option<Boolean> MILLISECONDS = new BooleanOption();
    }

    public static class LongOption
    extends FunctionOption<Long> {
        public LongOption() {
            super(Long.class, Long::parseLong);
        }
    }

    public static class IntegerOption
    extends FunctionOption<Integer> {
        public IntegerOption() {
            super(Integer.class, Integer::parseInt);
        }
    }

    public static class BooleanOption
    extends FunctionOption<Boolean> {
        public BooleanOption() {
            super(Boolean.class, Boolean::parseBoolean);
        }
    }

    public static class FunctionOption<T>
    extends AbstractOption<T> {
        private final Function<String, T> func;

        public FunctionOption(Class<T> clazz, Function<String, T> func) {
            super(clazz);
            Objects.requireNonNull(func);
            this.func = func;
        }

        @Override
        public T fromString(String value) {
            return this.func.apply(value);
        }
    }

    public static class StringOption
    extends AbstractOption<String> {
        public StringOption() {
            super(String.class);
        }

        @Override
        public String fromString(String value) {
            return value;
        }
    }

    public static abstract class AbstractOption<T>
    implements Option<T> {
        private final Class<T> clazz;

        public AbstractOption(Class<T> clazz) {
            Objects.requireNonNull(clazz);
            this.clazz = clazz;
        }

        @Override
        public T cast(Object value) {
            return this.clazz.cast(value);
        }
    }

    public static interface Option<T> {
        public T cast(Object var1);

        public T fromString(String var1);

        default public void put(CollectorBuilder builder, String value) {
            builder.option(this, this.fromString(value));
        }

        default public void apply(Map<?, ?> options, Consumer<T> consumer) {
            Object value = options.get(this);
            consumer.accept(this.cast(value));
        }

        default public void applyNonNull(Map<?, ?> options, Consumer<T> consumer) {
            Object value = options.get(this);
            if (value == null) {
                return;
            }
            consumer.accept(this.cast(value));
        }

        default public void applyNonNullOrElse(Map<?, ?> options, T defaultValue, Consumer<T> consumer) {
            Object value = options.get(this);
            if (value != null) {
                consumer.accept(this.cast(value));
            } else {
                consumer.accept(defaultValue);
            }
        }

        default public T orElse(Map<?, ?> options, T defaultValue) {
            Object value = options.get(this);
            if (value == null) {
                return defaultValue;
            }
            return this.cast(value);
        }

        default public T get(Map<?, ?> options) {
            return this.cast(options.get(this));
        }
    }
}

