/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector.camel.component;

import de.dentrassi.iot.opentsdb.collector.Collector;
import de.dentrassi.iot.opentsdb.collector.Data;
import de.dentrassi.iot.opentsdb.collector.camel.Value;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultAsyncProducer;

public class OpenTsdbProducer
extends DefaultAsyncProducer {
    private final Collector collector;
    private final String metric;
    private final Map<String, String> tags;

    public OpenTsdbProducer(Endpoint endpoint, Collector collector, String metric, Map<String, String> tags) {
        super(endpoint);
        this.collector = collector;
        this.metric = metric;
        this.tags = tags;
    }

    private void publish(Data[] data, Exchange exchange, AsyncCallback callback) {
        this.collector.publish(data).whenComplete((result, e) -> {
            if (e != null) {
                exchange.setException(e);
            }
            callback.done(false);
        });
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Value value;
        Value[] values;
        Data[] datas = (Data[])exchange.getIn().getBody(Data[].class);
        if (datas != null) {
            this.publish(datas, exchange, callback);
            return false;
        }
        Data data = (Data)exchange.getIn().getBody(Data.class);
        if (data != null) {
            this.publish(new Data[]{data}, exchange, callback);
            return false;
        }
        String metric = this.metric;
        Map tags = this.tags;
        if (exchange.getIn().getHeader("metric") != null) {
            metric = exchange.getIn().getHeader("metric").toString();
        }
        if (exchange.getIn().getHeader("tags") != null) {
            tags = (Map)exchange.getIn().getHeader("tags");
        }
        if ((values = (Value[])exchange.getIn().getBody(Value[].class)) == null && (value = (Value)exchange.getIn().getBody(Value.class)) != null) {
            values = new Value[]{value};
        }
        if (values != null) {
            if (metric == null) {
                exchange.setException((Throwable)new IllegalArgumentException("Unable to handle Value message type without metric"));
                callback.done(true);
                return true;
            }
            if (tags == null || tags.isEmpty()) {
                exchange.setException((Throwable)new IllegalArgumentException("Unable to handle Value message type without tags"));
                callback.done(true);
                return true;
            }
            Data[] data2 = new Data[values.length];
            for (int i = 0; i < data2.length; ++i) {
                Value value2 = values[i];
                data2[i] = value2.getValue() instanceof Long ? new Data(this.metric, value2.getValue().longValue(), value2.getTimestamp(), tags) : new Data(this.metric, value2.getValue().floatValue(), value2.getTimestamp(), tags);
            }
            this.publish(data2, exchange, callback);
            return false;
        }
        exchange.setException((Throwable)new IllegalArgumentException(String.format("Unable to handle body of '%s'", exchange.getIn().getBody() != null ? exchange.getIn().getBody().getClass() : "null")));
        callback.done(true);
        return true;
    }
}

