/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.opentsdb.collector.camel.component;

import de.dentrassi.iot.opentsdb.collector.Collector;
import de.dentrassi.iot.opentsdb.collector.CollectorBuilder;
import de.dentrassi.iot.opentsdb.collector.camel.component.OpenTsdbProducer;
import de.dentrassi.iot.opentsdb.collector.string.StringOptions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="open-tsdb", syntax="open-tsdb:uri?option1=value1&option2=value2", title="OpenTSDB", label="iot")
public class OpenTsdbEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private final String url;
    private final Map<String, Object> options;
    private Collector collector;

    public OpenTsdbEndpoint(String endpointUri, Component component, String remaining, Map<String, Object> parameters) throws MalformedURLException {
        super(endpointUri, component);
        this.url = remaining;
        this.options = parameters;
    }

    protected void doStart() throws Exception {
        URI uri = URI.create(this.url);
        String fragment = uri.getFragment();
        String baseUrl = fragment != null ? this.url.replaceFirst(Pattern.quote("#" + fragment) + "$", "") : uri.toString();
        CollectorBuilder builder = new CollectorBuilder(new URL(baseUrl));
        HashMap<String, String> stringOptions = new HashMap<String, String>(this.options.size());
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            stringOptions.put(key, value != null ? value.toString() : null);
        }
        StringOptions.putAll((CollectorBuilder)builder, stringOptions);
        this.collector = (Collector)builder.build().orElseThrow(() -> new IllegalArgumentException("Failed to create collector"));
    }

    protected void doStop() throws Exception {
        if (this.collector != null) {
            this.collector.close();
            this.collector = null;
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        String[] toks;
        String metric = null;
        HashMap<String, String> tags = null;
        String fragment = URI.create(this.url).getFragment();
        if (fragment != null && (toks = fragment.split("/")).length > 0) {
            metric = toks[0];
            tags = new HashMap<String, String>();
            for (int i = 1; i < toks.length; ++i) {
                String tagAndValue = toks[i];
                String[] tav = tagAndValue.split("=", 2);
                if (tav.length != 2) continue;
                tags.put(tav[0], tav[1]);
            }
        }
        return new OpenTsdbProducer((Endpoint)this, this.collector, metric, tags);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return null;
    }

    public boolean isSingleton() {
        return false;
    }
}

