/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.cayenne.lpp.types;

import java.util.Objects;

public abstract class NumericType<T extends Number>
extends Number {
    private static final long serialVersionUID = 1L;
    private final T value;

    public NumericType(T value) {
        this.value = (Number)Objects.requireNonNull(value);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return ((Number)this.value).intValue();
    }

    @Override
    public long longValue() {
        return ((Number)this.value).longValue();
    }

    @Override
    public float floatValue() {
        return ((Number)this.value).floatValue();
    }

    @Override
    public double doubleValue() {
        return ((Number)this.value).doubleValue();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericType other = (NumericType)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return String.format("[%s: %s]", this.getClass().getSimpleName(), this.value);
    }
}

