/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.cayenne.lpp.codec;

import de.dentrassi.iot.cayenne.lpp.codec.Codec;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class SimpleCodec<T>
implements Codec<T> {
    private final Function<ByteBuffer, T> getter;
    private final BiConsumer<ByteBuffer, T> setter;

    public SimpleCodec(Function<ByteBuffer, T> getter, BiConsumer<ByteBuffer, T> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public <I> SimpleCodec(Function<ByteBuffer, I> getter, Function<I, T> from, BiConsumer<ByteBuffer, I> setter, Function<T, I> to) {
        this.getter = b -> getter.andThen(from).apply((ByteBuffer)b);
        this.setter = (b, v) -> setter.accept((ByteBuffer)b, (Object)to.apply(v));
    }

    @Override
    public void encode(ByteBuffer buffer, T value) {
        this.setter.accept(buffer, (ByteBuffer)value);
    }

    @Override
    public T decode(ByteBuffer buffer) {
        return this.getter.apply(buffer);
    }
}

