/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.cayenne.lpp.codec;

import java.nio.ByteBuffer;

public interface Codec<T> {
    public void encode(ByteBuffer var1, T var2);

    public T decode(ByteBuffer var1);

    public static void putShort(ByteBuffer buffer, float value, float factor) {
        int v = (int)(value / factor);
        buffer.put((byte)(v >> 8));
        buffer.put((byte)v);
    }

    public static float getShort(ByteBuffer buffer, float factor) {
        byte b1 = buffer.get();
        byte b2 = buffer.get();
        int value = b1 << 8 | b2 & 0xFF;
        return (float)value * factor;
    }

    public static void putMedium(ByteBuffer buffer, float value, float factor) {
        int v = (int)(value / factor);
        buffer.put((byte)(v >> 16));
        buffer.put((byte)(v >> 8));
        buffer.put((byte)v);
    }

    public static float getMedium(ByteBuffer buffer, float factor) {
        byte b1 = buffer.get();
        byte b2 = buffer.get();
        byte b3 = buffer.get();
        int value = b1 << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        return (float)value * factor;
    }
}

