/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.cayenne.lpp;

import de.dentrassi.iot.cayenne.lpp.Entry;
import de.dentrassi.iot.cayenne.lpp.Message;
import de.dentrassi.iot.cayenne.lpp.codec.AccelerometerCodec;
import de.dentrassi.iot.cayenne.lpp.codec.Codec;
import de.dentrassi.iot.cayenne.lpp.codec.GpsCodec;
import de.dentrassi.iot.cayenne.lpp.codec.GyrometerCodec;
import de.dentrassi.iot.cayenne.lpp.codec.SimpleCodec;
import de.dentrassi.iot.cayenne.lpp.types.AnalogInput;
import de.dentrassi.iot.cayenne.lpp.types.AnalogOutput;
import de.dentrassi.iot.cayenne.lpp.types.BarometricPressure;
import de.dentrassi.iot.cayenne.lpp.types.DigitalInput;
import de.dentrassi.iot.cayenne.lpp.types.DigitalOutput;
import de.dentrassi.iot.cayenne.lpp.types.Luminosity;
import de.dentrassi.iot.cayenne.lpp.types.NumericType;
import de.dentrassi.iot.cayenne.lpp.types.Presence;
import de.dentrassi.iot.cayenne.lpp.types.RelativeHumidity;
import de.dentrassi.iot.cayenne.lpp.types.Temperature;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Parser {
    private final Codec<?>[] typeMap;
    private static final Parser DEFAULT_PARSER = new Builder().registerType((byte)0, new SimpleCodec<DigitalInput>(ByteBuffer::get, DigitalInput::new, ByteBuffer::put, NumericType::getValue)).registerType((byte)1, new SimpleCodec<DigitalOutput>(ByteBuffer::get, DigitalOutput::new, ByteBuffer::put, NumericType::getValue)).registerType((byte)2, new SimpleCodec<AnalogInput>(b -> Float.valueOf(Codec.getShort(b, 0.01f)), AnalogInput::new, (b, v) -> Codec.putShort(b, v.floatValue(), 0.01f), NumericType::getValue)).registerType((byte)3, new SimpleCodec<AnalogOutput>(b -> Float.valueOf(Codec.getShort(b, 0.01f)), AnalogOutput::new, (b, v) -> Codec.putShort(b, v.floatValue(), 0.01f), NumericType::getValue)).registerType((byte)101, new SimpleCodec<Luminosity>(b -> Short.toUnsignedInt(b.getShort()), Luminosity::new, (b, v) -> b.putShort((short)v.intValue()), NumericType::getValue)).registerType((byte)102, new SimpleCodec<Presence>(ByteBuffer::get, Presence::new, ByteBuffer::put, NumericType::getValue)).registerType((byte)103, new SimpleCodec<Temperature>(b -> Float.valueOf(Codec.getShort(b, 0.1f)), Temperature::new, (b, v) -> Codec.putShort(b, v.floatValue(), 0.1f), NumericType::getValue)).registerType((byte)104, new SimpleCodec<RelativeHumidity>(b -> Float.valueOf(Codec.getShort(b, 0.5f)), RelativeHumidity::new, (b, v) -> Codec.putShort(b, v.floatValue(), 0.5f), NumericType::getValue)).registerType((byte)113, new AccelerometerCodec()).registerType((byte)115, new SimpleCodec<BarometricPressure>(b -> Float.valueOf(Codec.getShort(b, 0.1f)), BarometricPressure::new, (b, v) -> Codec.putShort(b, v.floatValue(), 0.1f), NumericType::getValue)).registerType((byte)-122, new GyrometerCodec()).registerType((byte)-120, new GpsCodec()).build();

    public static Parser defaultParser() {
        return DEFAULT_PARSER;
    }

    private Parser(Codec<?>[] typeMap) {
        this.typeMap = typeMap;
    }

    private Entry parseNext(ByteBuffer buffer) {
        byte channel = buffer.get();
        byte id = buffer.get();
        Codec<?> codec = this.typeMap[Byte.toUnsignedInt(id)];
        if (codec == null) {
            throw new IllegalArgumentException(String.format("Unknown object type: %02x", id));
        }
        return new Entry(channel, codec.decode(buffer));
    }

    public Stream<Entry> decode(ByteBuffer buffer) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.toIterator(buffer.order(ByteOrder.BIG_ENDIAN)), 1296), false);
    }

    private Iterator<Entry> toIterator(final ByteBuffer buffer) {
        return new Iterator<Entry>(){

            @Override
            public Entry next() {
                return Parser.this.parseNext(buffer);
            }

            @Override
            public boolean hasNext() {
                return buffer.hasRemaining();
            }
        };
    }

    public static Stream<Entry> stream(ByteBuffer buffer) {
        return DEFAULT_PARSER.decode(buffer);
    }

    public static Message parseMessage(ByteBuffer buffer) {
        return new Message(Parser.stream(buffer).collect(Collectors.toList()));
    }

    public static class Builder {
        private final Codec<?>[] typeMap = new Codec[255];

        public Builder registerType(byte id, Codec<?> codec) {
            this.typeMap[Byte.toUnsignedInt((byte)id)] = codec;
            return this;
        }

        public Parser build() {
            return new Parser(this.typeMap);
        }
    }
}

