/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.iot.cayenne.lpp;

import de.dentrassi.iot.cayenne.lpp.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Message {
    private final List<Entry> entries;
    private final Map<Integer, Entry> map;

    public Message(Collection<Entry> entries) {
        this.entries = new ArrayList<Entry>(entries);
        this.map = new HashMap<Integer, Entry>(entries.size());
        for (Entry entry : entries) {
            this.map.put(entry.getChannel(), entry);
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry getEntry(int channel) {
        return this.map.get(channel);
    }

    public <T> T getEntry(int channel, Class<T> clazz) {
        Entry entry = this.getEntry(channel);
        if (entry == null) {
            return null;
        }
        Object v = entry.getValue();
        if (clazz.isInstance(v)) {
            return clazz.cast(v);
        }
        return null;
    }
}

