/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.mqtt.internal.io.vertx.mqtt;

import de.dentrassi.flow.component.mqtt.internal.io.vertx.mqtt.impl.MqttClientImpl;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubAckMessage;
import java.util.Map;

public interface MqttClient {
    public static MqttClient create(Vertx vertx, MqttClientOptions options) {
        return new MqttClientImpl(vertx, options);
    }

    public static MqttClient create(Vertx vertx) {
        return new MqttClientImpl(vertx, new MqttClientOptions());
    }

    public MqttClient connect(int var1, String var2, Handler<AsyncResult<MqttConnAckMessage>> var3);

    public MqttClient connect(int var1, String var2, String var3, Handler<AsyncResult<MqttConnAckMessage>> var4);

    public MqttClient disconnect();

    public MqttClient disconnect(Handler<AsyncResult<Void>> var1);

    public MqttClient publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5);

    public MqttClient publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, Handler<AsyncResult<Integer>> var6);

    public MqttClient publishCompletionHandler(Handler<Integer> var1);

    public MqttClient publishHandler(Handler<MqttPublishMessage> var1);

    public MqttClient subscribeCompletionHandler(Handler<MqttSubAckMessage> var1);

    public MqttClient subscribe(String var1, int var2);

    public MqttClient subscribe(String var1, int var2, Handler<AsyncResult<Integer>> var3);

    public MqttClient subscribe(Map<String, Integer> var1);

    public MqttClient subscribe(Map<String, Integer> var1, Handler<AsyncResult<Integer>> var2);

    public MqttClient unsubscribeCompletionHandler(Handler<Integer> var1);

    public MqttClient unsubscribe(String var1);

    public MqttClient unsubscribe(String var1, Handler<AsyncResult<Integer>> var2);

    public MqttClient pingResponseHandler(Handler<Void> var1);

    public MqttClient exceptionHandler(Handler<Throwable> var1);

    public MqttClient closeHandler(Handler<Void> var1);

    public MqttClient ping();

    public String clientId();

    public boolean isConnected();
}

