/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.mqtt;

import de.dentrassi.flow.spi.component.AnnotatedComponent;
import de.dentrassi.flow.spi.component.DataIn;
import de.dentrassi.flow.spi.component.DataPortIn;
import de.dentrassi.flow.spi.component.SimpleSingleDataPortIn;
import de.dentrassi.flow.spi.component.TriggerIn;
import de.dentrassi.flow.spi.component.ValueResult;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPublish
extends AnnotatedComponent {
    private static final Logger logger = LoggerFactory.getLogger(MqttPublish.class);
    private MqttClient client;
    private String topic;
    private final SimpleSingleDataPortIn payload;
    private MqttQoS qos = MqttQoS.AT_MOST_ONCE;

    public MqttPublish() {
        this.payload = (SimpleSingleDataPortIn)this.registerDataIn("payload", (DataPortIn)new SimpleSingleDataPortIn());
    }

    @TriggerIn
    public void publish() {
        if (this.client == null) {
            logger.debug("No client");
            return;
        }
        ValueResult value = this.payload.getValue();
        if (value == null) {
            logger.debug("No payload data found");
            return;
        }
        boolean published = false;
        for (Object v : value.getValues()) {
            if (v instanceof String) {
                this.publish(Buffer.buffer((String)((String)v)));
                published = true;
            } else if (v instanceof byte[]) {
                this.publish(Buffer.buffer((byte[])((byte[])v)));
                published = true;
            }
            if (!published) continue;
            break;
        }
        if (!published) {
            throw new IllegalStateException("Unable to accept payload type - possible choices: " + value);
        }
    }

    private void publish(Buffer payload) {
        this.client.publish(this.topic, payload, this.qos, false, false);
    }

    @DataIn
    public void setQos(Integer qos) {
        if (qos == null) {
            this.setQos(MqttQoS.AT_MOST_ONCE);
            return;
        }
        switch (qos) {
            case 0: {
                this.setQos(MqttQoS.AT_MOST_ONCE);
                return;
            }
            case 1: {
                this.setQos(MqttQoS.AT_LEAST_ONCE);
                return;
            }
            case 2: {
                this.setQos(MqttQoS.EXACTLY_ONCE);
                return;
            }
        }
    }

    private void setQos(MqttQoS qos) {
        this.qos = qos;
    }

    @DataIn
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @DataIn(initialize=false)
    public void setClient(MqttClient client) {
        this.client = client;
    }
}

