/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.mqtt;

import de.dentrassi.flow.ComponentContext;
import de.dentrassi.flow.spi.component.AnnotatedComponent;
import de.dentrassi.flow.spi.component.DataIn;
import de.dentrassi.flow.spi.component.DataOut;
import de.dentrassi.flow.spi.component.TriggerIn;
import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttClientOptions;
import java.util.Map;

public class MqttClient
extends AnnotatedComponent {
    private String host;
    private int port;
    private String clientId;
    private String username;
    private String password;
    private ComponentContext.SharedResource<Vertx> vertx;
    private io.vertx.mqtt.MqttClient client;

    public MqttClient() {
        this.registerTriggerOut("connected");
    }

    public void start(Map<String, String> initializers, ComponentContext context) {
        super.start(initializers, context);
        this.vertx = context.createSharedResource(MqttClient.class, "vertx", Vertx.class, () -> Vertx.vertx(), Vertx::close);
    }

    public void stop() {
        this.disconnect();
        this.vertx.close();
        super.stop();
    }

    @TriggerIn
    public void connect() {
        MqttClientOptions options = new MqttClientOptions();
        if (this.clientId != null) {
            options.setAutoGeneratedClientId(false);
            options.setClientId(this.clientId);
        } else {
            options.setAutoGeneratedClientId(true);
        }
        options.setAutoKeepAlive(true);
        options.setUsername(this.username);
        options.setPassword(this.password);
        this.client = io.vertx.mqtt.MqttClient.create((Vertx)((Vertx)this.vertx.get()), (MqttClientOptions)options);
        this.client.connect(this.port, this.host, connected -> this.connected());
    }

    @TriggerIn
    public void disconnect() {
        this.client.disconnect();
    }

    private void connected() {
        this.triggerOut("connected");
    }

    @DataIn
    public void setHost(String host) {
        this.host = host;
    }

    @DataIn
    public void setPort(String port) {
        this.port = port == null ? 1883 : Integer.parseInt(port);
    }

    @DataIn
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @DataIn
    public void setUsername(String username) {
        this.username = username;
    }

    @DataIn
    public void setPassword(String password) {
        this.password = password;
    }

    @DataOut
    public io.vertx.mqtt.MqttClient getClient() {
        return this.client;
    }
}

