/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.kapua;

import de.dentrassi.flow.spi.component.AnnotatedComponent;
import de.dentrassi.flow.spi.component.DataIn;
import de.dentrassi.flow.spi.component.DataOut;
import de.dentrassi.flow.spi.component.TriggerIn;
import de.dentrassi.flow.spi.component.TriggerOut;
import org.eclipse.kapua.client.gateway.Client;
import org.eclipse.kapua.client.gateway.Credentials;
import org.eclipse.kapua.client.gateway.Transport;
import org.eclipse.kapua.client.gateway.mqtt.fuse.FuseChannel;
import org.eclipse.kapua.client.gateway.profile.kura.KuraMqttProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapuaClient
extends AnnotatedComponent {
    private static final Logger logger = LoggerFactory.getLogger(KapuaClient.class);
    private String accountName;
    private String clientId;
    private String brokerUrl;
    private String username;
    private String password;
    private Client client;
    private Transport.ListenerHandle listenerHandle;
    private boolean connected;
    private Runnable connectionEstablished;
    private Runnable connectionLost;
    private Runnable clientCreated;
    private Runnable clientDisposed;

    @DataIn
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @DataIn
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @DataIn
    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    @DataIn
    public void setUsername(String username) {
        this.username = username;
    }

    @DataIn
    public void setPassword(String password) {
        this.password = password;
    }

    @DataOut
    public Client getClient() {
        return this.client;
    }

    @TriggerOut
    public void setConnectionEstablished(Runnable connectionEstablished) {
        this.connectionEstablished = connectionEstablished;
    }

    @TriggerOut
    public void setConnectionLost(Runnable connectionLost) {
        this.connectionLost = connectionLost;
    }

    @TriggerOut
    public void setClientCreated(Runnable clientCreated) {
        this.clientCreated = clientCreated;
    }

    @TriggerOut
    public void setClientDisposed(Runnable clientDisposed) {
        this.clientDisposed = clientDisposed;
    }

    @DataOut
    public boolean isConnected() {
        return this.connected;
    }

    @TriggerIn
    public void connect() throws Exception {
        logger.info("Connecting client - broker: {}, clientId: {}", (Object)this.brokerUrl, (Object)this.clientId);
        KuraMqttProfile builder = KuraMqttProfile.newProfile(FuseChannel.Builder::new).accountName(this.accountName).clientId(this.clientId).brokerUrl(this.brokerUrl);
        if (this.username != null && this.password != null) {
            builder.credentials(Credentials.userAndPassword((String)this.username, (String)this.password));
        }
        this.client = builder.build();
        this.listenerHandle = this.client.transport().listen(connected -> this.runOnContext(() -> this.handleConnectionStateChange(connected)));
        logger.info("Created client - broker: {}, clientId: {}", (Object)this.brokerUrl, (Object)this.clientId);
        this.clientCreated.run();
    }

    @TriggerIn
    public void disconnect() throws Exception {
        this.clientDisposed.run();
        if (this.listenerHandle != null) {
            this.listenerHandle.close();
            this.listenerHandle = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    private void handleConnectionStateChange(boolean connected) {
        logger.info("Connection state changed: {}", (Object)connected);
        this.connected = connected;
        if (connected) {
            this.connectionEstablished.run();
        } else {
            this.connectionLost.run();
        }
    }
}

