/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.kapua;

import de.dentrassi.flow.spi.component.AnnotatedComponent;
import de.dentrassi.flow.spi.component.DataIn;
import de.dentrassi.flow.spi.component.TriggerIn;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.kapua.client.gateway.Application;
import org.eclipse.kapua.client.gateway.Payload;
import org.eclipse.kapua.client.gateway.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapuaTopic
extends AnnotatedComponent {
    private static final Logger logger = LoggerFactory.getLogger(KapuaTopic.class);
    private Application application;
    private Topic topic;
    private Map<?, ?> payload;

    @DataIn(initialize=false)
    public void setApplication(Application application) {
        this.application = application;
    }

    @DataIn
    public void setTopic(String topic) {
        this.topic = Topic.split((String)topic);
    }

    @DataIn
    public void setPayload(Map<?, ?> payload) {
        this.payload = payload;
    }

    @TriggerIn
    public void publish() {
        if (this.payload == null) {
            return;
        }
        Map<String, Object> payload = this.payload.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
        this.application.data(this.topic).send(Payload.of(payload)).whenComplete((v, e) -> {
            if (e != null) {
                logger.warn("Failed to publish", e);
            }
        });
    }
}

