/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.flow.component.kapua;

import de.dentrassi.flow.spi.component.AnnotatedComponent;
import de.dentrassi.flow.spi.component.DataIn;
import de.dentrassi.flow.spi.component.DataOut;
import de.dentrassi.flow.spi.component.TriggerIn;
import org.eclipse.kapua.client.gateway.Application;
import org.eclipse.kapua.client.gateway.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapuaApplication
extends AnnotatedComponent {
    private static final Logger logger = LoggerFactory.getLogger(KapuaApplication.class);
    private Client client;
    private String applicationId;
    private Application application;

    @DataIn(initialize=false)
    public void setClient(Client client) {
        this.client = client;
    }

    @DataOut
    public Application getApplication() {
        return this.application;
    }

    @DataIn
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @TriggerIn
    public void create() {
        logger.info("Create application: {}", (Object)this.applicationId);
        this.application = this.client.buildApplication(this.applicationId).build();
    }

    @TriggerIn
    public void dispose() throws Exception {
        logger.info("Dispose application: {}", (Object)this.applicationId);
        if (this.application != null) {
            try {
                this.application.close();
            }
            finally {
                this.application = null;
            }
        }
    }
}

