/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.syslog;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.protocol.syslog.Facility;
import org.eclipse.scada.protocol.syslog.Severity;
import org.eclipse.scada.protocol.syslog.SyslogMessage;
import org.eclipse.scada.protocol.syslog.time.TimestampParser;

public class SyslogCodec
extends ChannelDuplexHandler {
    private static final byte PRI_START = 60;
    private static final byte PRI_END = 62;
    private static final byte COLON = 58;
    private final TimestampParser timestampParser;
    private static final Pattern PROCESS_PATTERN = Pattern.compile("(.*)\\[(\\d+)\\]");

    public SyslogCodec(TimestampParser timestampParser) {
        this.timestampParser = timestampParser;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.processMessage(ctx, (ByteBuf)msg);
        }
    }

    protected void processMessage(ChannelHandlerContext ctx, ByteBuf msg) {
        if (msg.readByte() != 60) {
            throw new CodecException("PRI start not found");
        }
        int prival = this.decodePrival(msg);
        Severity severity = Severity.values()[prival % 8];
        Facility facility = Facility.values()[prival / 8];
        Calendar timestamp = this.timestampParser.parseTimestamp(msg);
        String hostname = this.decodeHostname(msg);
        String[] process = this.decodeProcess(msg);
        String processName = process[0];
        Long processId = process.length > 1 ? Long.valueOf(Long.parseLong(process[1])) : null;
        String message = this.decodeMessage(msg);
        ctx.fireChannelRead((Object)new SyslogMessage(facility, severity, timestamp, hostname, processName, processId, message));
    }

    private String decodeMessage(ByteBuf msg) {
        String data = msg.toString(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (c == '#') {
                try {
                    int code = Integer.parseInt(data.substring(i + 1, i + 4), 8);
                    sb.append((char)code);
                    i += 3;
                }
                catch (NumberFormatException numberFormatException) {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String[] decodeProcess(ByteBuf msg) {
        Matcher m;
        int spaceIndex = msg.bytesBefore((byte)58);
        if (spaceIndex < 0) {
            throw new CodecException("Unable to find process name");
        }
        String process = msg.readSlice(spaceIndex).toString(StandardCharsets.US_ASCII);
        msg.skipBytes(1);
        if (msg.isReadable()) {
            msg.skipBytes(1);
        }
        if ((m = PROCESS_PATTERN.matcher(process)).matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[]{process};
    }

    private String decodeHostname(ByteBuf msg) {
        int spaceIndex = msg.bytesBefore((byte)32);
        if (spaceIndex < 0) {
            throw new CodecException("Unable to find hostname");
        }
        String hostname = msg.readSlice(spaceIndex).toString(StandardCharsets.US_ASCII);
        msg.skipBytes(1);
        return hostname;
    }

    private int decodePrival(ByteBuf msg) {
        byte b;
        ByteBuffer privalBuffer = ByteBuffer.wrap(new byte[3]);
        while ((b = msg.readByte()) != 62) {
            if (!privalBuffer.hasRemaining()) {
                throw new CodecException("PRI value must be <=3 bytes");
            }
            privalBuffer.put(b);
        }
        privalBuffer.flip();
        int prival = Integer.parseInt(StandardCharsets.US_ASCII.decode(privalBuffer).toString());
        return prival;
    }
}

