/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PemKeyStore
extends KeyStoreSpi {
    private Map<String, Object> objects = Collections.emptyMap();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Object obj = this.objects.get(alias);
        if (obj instanceof Certificate) {
            return (Certificate)obj;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Object obj = this.objects.get(alias);
        if (obj instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)obj;
            return xcert.getNotBefore();
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Unsupported operation");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Unsupported operation");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Unsupported operation");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("Unsupported operation");
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<String> keys = this.objects.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public String nextElement() {
                return (String)keys.next();
            }

            @Override
            public boolean hasMoreElements() {
                return keys.hasNext();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.objects.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.objects.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.objects.get(alias) instanceof X509Certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        for (Map.Entry<String, Object> entry : this.objects.entrySet()) {
            if (entry.getValue() != cert) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        PemObject pem;
        if (stream == null) {
            throw new IOException("KeyStore requires input stream");
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        PemReader reader = new PemReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        HashMap<String, Certificate> objects = new HashMap<String, Certificate>();
        int certIndex = 0;
        while ((pem = reader.readPemObject()) != null) {
            if (!"CERTIFICATE".equals(pem.getType())) continue;
            for (Certificate certificate : factory.generateCertificates(new ByteArrayInputStream(pem.getContent()))) {
                if (!(certificate instanceof X509Certificate)) continue;
                objects.put("cert-" + certIndex, certificate);
                ++certIndex;
            }
        }
        this.objects = Collections.unmodifiableMap(objects);
    }
}

