/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.camel.neoscada.server;

import de.dentrassi.camel.neoscada.server.CamelHive;
import de.dentrassi.camel.neoscada.server.ServerComponent;
import de.dentrassi.camel.neoscada.server.ServerConsumer;
import de.dentrassi.camel.neoscada.server.ServerProducer;
import de.dentrassi.camel.neoscada.server.interal.Exceptions;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class ServerEndpoint
extends DefaultEndpoint {
    private ServerComponent component;
    private final CamelHive hive;
    private final DataItemInputOutputChained item;
    private final Set<ServerConsumer> consumers = new CopyOnWriteArraySet<ServerConsumer>();

    public ServerEndpoint(String endpointUri, ServerComponent component, CamelHive hive, String itemId) {
        super(endpointUri, (Component)component);
        this.component = component;
        this.hive = hive;
        this.item = new DataItemInputOutputChained(itemId, hive.getOperationService()){

            protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
                return ServerEndpoint.this.handleCommand(value, operationParameters);
            }
        };
        this.hive.registerItem((DataItem)this.item);
    }

    public ServerComponent getComponent() {
        return this.component;
    }

    protected NotifyFuture<WriteResult> handleCommand(final Variant value, final OperationParameters operationParameters) {
        final CopyOnWriteArraySet<ServerConsumer> consumers = new CopyOnWriteArraySet<ServerConsumer>(this.consumers);
        if (consumers.isEmpty()) {
            return new InstantErrorFuture((Throwable)new UnsupportedOperationException("Write not supported"));
        }
        FutureTask task = new FutureTask(new Runnable(){

            @Override
            public void run() {
                LinkedList<Exception> errors = null;
                for (ServerConsumer consumer : consumers) {
                    try {
                        consumer.processWrite(value, operationParameters);
                    }
                    catch (Exception e) {
                        if (errors == null) {
                            errors = new LinkedList<Exception>();
                        }
                        errors.add(e);
                    }
                }
                Exceptions.handleRuntimeErrors(errors);
            }
        }, (Object)WriteResult.OK);
        this.component.getExecutor().execute((Runnable)task);
        return task;
    }

    public Producer createProducer() throws Exception {
        return new ServerProducer(this, this.item);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ServerConsumer(this, processor){

            protected void doStart() throws Exception {
                super.doStart();
                ServerEndpoint.this.registerConsumer(this);
            }

            protected void doStop() throws Exception {
                ServerEndpoint.this.unregisterConsumer(this);
                super.doStop();
            }
        };
    }

    protected void registerConsumer(ServerConsumer serverConsumer) {
        this.consumers.add(serverConsumer);
    }

    protected void unregisterConsumer(ServerConsumer serverConsumer) {
        this.consumers.remove((Object)serverConsumer);
    }

    public boolean isSingleton() {
        return true;
    }
}

