/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.camel.neoscada.server;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import de.dentrassi.camel.neoscada.server.CamelHive;
import de.dentrassi.camel.neoscada.server.HiveRunner;
import de.dentrassi.camel.neoscada.server.ServerEndpoint;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;

public class ServerComponent
extends UriEndpointComponent {
    private int port = 2101;
    private CamelHive hive;
    private HiveRunner runner;
    private ExecutorService executor;
    private final Escaper esc = UrlEscapers.urlFormParameterEscaper();

    public ServerComponent() {
        super(ServerEndpoint.class);
    }

    public ServerComponent(CamelContext context) {
        super(context, ServerEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new ServerEndpoint(uri, this, this.hive, remaining);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "NeoSCADAComponent");
        this.hive = new CamelHive();
        this.runner = new HiveRunner((Hive)this.hive, this.makeProtocol(), this.makeAddresses());
    }

    protected void doStop() throws Exception {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
        if (this.executor != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    private ProtocolConfigurationFactory makeProtocol() {
        return new ProtocolConfigurationFactoryImpl(ConnectionInformation.fromURI((String)this.makeUri()));
    }

    private String makeUri() {
        HashMap parameters = new HashMap();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : parameters.entrySet()) {
            if (sb.length() == 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(this.esc.escape((String)entry.getKey()));
            sb.append("=");
            sb.append(this.esc.escape((String)entry.getValue()));
        }
        return String.format("da:ngp://%s:%s%s", "dummy", this.port, sb);
    }

    private Collection<InetSocketAddress> makeAddresses() {
        return Collections.singletonList(new InetSocketAddress(this.port));
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

