/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.camel.neoscada.server;

import de.dentrassi.camel.neoscada.server.interal.Exceptions;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.ngp.Exporter;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;

public class HiveRunner
implements AutoCloseable {
    private final Hive hive;
    private final Exporter exporter;

    public HiveRunner(Hive hive, ProtocolConfigurationFactory protocolConfigurationFactory, Collection<InetSocketAddress> addresses) throws Exception {
        this.hive = hive;
        this.hive.start();
        this.exporter = new Exporter(hive, protocolConfigurationFactory, addresses);
        try {
            this.exporter.start();
        }
        catch (Exception e) {
            hive.stop();
            throw e;
        }
    }

    @Override
    public void close() throws Exception {
        LinkedList<Exception> errors = new LinkedList<Exception>();
        if (this.hive != null) {
            try {
                this.hive.stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (this.exporter != null) {
            try {
                this.exporter.stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        Exceptions.handleErrors(errors);
    }
}

